/*
 * Decompiled with CFR 0.152.
 */
package com.github.code2358.javacard.jcdk.config;

import java.util.Objects;
import java.util.regex.Pattern;

public final class AppletClass {
    private final String appletClass;

    public AppletClass(String appletClass) {
        Objects.requireNonNull(appletClass);
        Pattern pattern = Pattern.compile("[0-9a-z]+(\\.[0-9a-z]+)*\\.[0-9a-zA-Z]+");
        if (!pattern.matcher(appletClass).matches()) {
            throw new IllegalArgumentException("Applet class must be fully qualified. For example: com.company.MyApplet");
        }
        this.appletClass = appletClass;
    }

    public String getPackage() {
        return this.appletClass.substring(0, this.appletClass.lastIndexOf("."));
    }

    public String toString() {
        return this.appletClass;
    }
}

