/*
 * Decompiled with CFR 0.152.
 */
package com.github.code2358.javacard.jcdk.config;

import java.util.Objects;
import java.util.regex.Pattern;

public final class AppletId {
    private final String appletId;

    public AppletId(String appletId) {
        Objects.requireNonNull(appletId);
        Pattern pattern = Pattern.compile("[0-9A-Fa-f][0-9A-Fa-f](:[0-9A-Fa-f][0-9A-Fa-f]){5,11}");
        if (!pattern.matcher(appletId).matches()) {
            throw new IllegalArgumentException("Invalid format of applet ID. Supported formats: 01:02:03:04:05:06 - 01:02:03:04:05:06:07:08:09:10:11:12");
        }
        this.appletId = appletId;
    }

    public String getPackageId() {
        return this.appletId.substring(0, 14);
    }

    public String toString() {
        return this.appletId;
    }
}

