/*
 * Decompiled with CFR 0.152.
 */
package com.github.code2358.javacard.jcdk.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public final class StreamPipe
extends Thread {
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean pipeInProgress = true;

    StreamPipe(InputStream inputStream, OutputStream outputStream) {
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(outputStream);
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[1024];
        try {
            while (this.pipeInProgress) {
                if (this.inputStream.available() <= 0) continue;
                int length = this.inputStream.read(buffer);
                this.outputStream.write(buffer, 0, length);
            }
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopPipe() {
        this.pipeInProgress = false;
    }
}

