/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.autoconfig.commonconfig.config.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import tk.mybatis.spring.annotation.MapperScan;

@Configuration
@MapperScan(basePackages={"com.jcl.pbcms.mapper"}, sqlSessionFactoryRef="masterSqlSessionFactory")
public class MasterDataSourceConfig {
    private Logger logger = LoggerFactory.getLogger(MasterDataSourceConfig.class);
    static final String MASTER_PACKAGE = "com.jcl.pbcms.mapper";
    private static final String MASTER_MAPPER_LOCAL = "classpath:mybatis/mapper/*.xml";
    @Autowired
    private WallFilter wallFilter;

    @Bean(name={"masterDataSource"})
    @Primary
    @ConfigurationProperties(prefix="druid.datasource")
    public DataSource masterDruidDataSource() {
        DruidDataSource datasource = new DruidDataSource();
        ArrayList<WallFilter> filters = new ArrayList<WallFilter>();
        filters.add(this.wallFilter);
        datasource.setProxyFilters(filters);
        return datasource;
    }

    @Bean(name={"masterSqlSessionFactory"})
    @Primary
    public SqlSessionFactory masterSqlSessionFactory() {
        SqlSessionFactoryBean sessionFactoryBean = new SqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(this.masterDruidDataSource());
        try {
            sessionFactoryBean.setConfigLocation((Resource)new ClassPathResource("mybatis/mybatis-config.xml"));
            sessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(MASTER_MAPPER_LOCAL));
            return sessionFactoryBean.getObject();
        }
        catch (Exception e) {
            this.logger.error("\u914d\u7f6e\u4e3b\u5e93\u7684SqlSessionFactory\u5931\u8d25\uff0cerror:{}", (Object)e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    @Bean(name={"masterTransactionManager"})
    @Primary
    public DataSourceTransactionManager masterTransactionManager() {
        return new DataSourceTransactionManager(this.masterDruidDataSource());
    }

    @Bean(name={"wallFilter"})
    @DependsOn(value={"wallConfig"})
    public WallFilter wallFilter(WallConfig wallConfig) {
        WallFilter wallFilter = new WallFilter();
        wallFilter.setConfig(wallConfig);
        return wallFilter;
    }

    @Bean(name={"wallConfig"})
    public WallConfig wallConfig() {
        WallConfig wallConfig = new WallConfig();
        wallConfig.setMultiStatementAllow(true);
        wallConfig.setNoneBaseStatementAllow(true);
        return wallConfig;
    }
}

