/*
 * Decompiled with CFR 0.152.
 */
package org.cg.rooster.phoenix;

import com.google.common.base.Preconditions;
import java.util.Properties;
import org.apache.hadoop.hbase.util.Strings;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class PhoenixDataSource
extends DriverManagerDataSource {
    protected String phoenixDriverClassName;
    protected String phoenixConnectionUrl;
    protected Integer upsertBatchSize;
    protected Boolean autocommit;
    protected String tenantId;
    private static final Integer DEFAULT_UPSERT_BATCH_SIZE = 1000;
    private static final String TENANT_ID_ATTRIB = "TenantId";
    private static final String UPSERT_BATCH_SIZE_ATTRIB = "UpsertBatchSize";
    private static final String AUTO_COMMIT_ATTRIB = "AutoCommit";

    public PhoenixDataSource() {
    }

    public PhoenixDataSource(String phoenixDriverClassName, String phoenixConnectionUrl) {
        this(phoenixDriverClassName, phoenixConnectionUrl, true);
    }

    public PhoenixDataSource(String phoenixDriverClassName, String phoenixConnectionUrl, Boolean autocommit) {
        this(phoenixDriverClassName, phoenixConnectionUrl, autocommit, DEFAULT_UPSERT_BATCH_SIZE);
    }

    public PhoenixDataSource(String phoenixDriverClassName, String phoenixConnectionUrl, Boolean autocommit, Integer upsertBatchSize) {
        this(phoenixDriverClassName, phoenixConnectionUrl, autocommit, upsertBatchSize, null);
    }

    public PhoenixDataSource(String phoenixDriverClassName, String phoenixConnectionUrl, Boolean autocommit, Integer upsertBatchSize, String tenantId) {
        this.setPhoenixDriverClassName(phoenixDriverClassName);
        this.setPhoenixConnectionUrl(phoenixConnectionUrl);
        this.setAutocommit(autocommit);
        this.setUpsertBatchSize(upsertBatchSize);
        this.setTenantId(tenantId);
    }

    public String getPhoenixDriverClassName() {
        return this.phoenixDriverClassName;
    }

    public void setPhoenixDriverClassName(String phoenixDriverClassName) {
        Preconditions.checkArgument((!Strings.isEmpty((String)phoenixDriverClassName) ? 1 : 0) != 0, (Object)"phoenixDriverClassName must be provided");
        this.phoenixDriverClassName = phoenixDriverClassName;
        this.setDriverClassName(phoenixDriverClassName);
    }

    public String getPhoenixConnectionUrl() {
        return this.phoenixConnectionUrl;
    }

    public void setPhoenixConnectionUrl(String phoenixConnectionUrl) {
        Preconditions.checkArgument((!Strings.isEmpty((String)phoenixConnectionUrl) ? 1 : 0) != 0, (Object)"phoenixConnectionUrl must be provided");
        this.phoenixConnectionUrl = phoenixConnectionUrl;
        this.setUrl(phoenixConnectionUrl);
    }

    public Boolean isAutocommit() {
        return this.autocommit;
    }

    public void setAutocommit(Boolean autocommit) {
        Preconditions.checkNotNull((Object)autocommit, (Object)"autocommit must be provided");
        this.autocommit = autocommit;
        this.setConnectionProperty(AUTO_COMMIT_ATTRIB, autocommit.toString());
    }

    public Integer getUpsertBatchSize() {
        return this.upsertBatchSize;
    }

    public void setUpsertBatchSize(Integer upsertBatchSize) {
        Integer batchSize;
        Preconditions.checkArgument((upsertBatchSize != null && upsertBatchSize > 0 ? 1 : 0) != 0, (Object)"upsertBatchSize must be valid");
        this.upsertBatchSize = upsertBatchSize;
        Integer n = batchSize = upsertBatchSize != null ? upsertBatchSize : DEFAULT_UPSERT_BATCH_SIZE;
        if (this.autocommit.booleanValue()) {
            this.setConnectionProperty(UPSERT_BATCH_SIZE_ATTRIB, batchSize.toString());
        }
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        if (!Strings.isEmpty((String)tenantId)) {
            this.tenantId = tenantId;
            this.setConnectionProperty(TENANT_ID_ATTRIB, tenantId);
        }
    }

    private void setConnectionProperty(String key, String value) {
        Preconditions.checkArgument((!Strings.isEmpty((String)key) ? 1 : 0) != 0, (Object)"key must be provided");
        Preconditions.checkArgument((!Strings.isEmpty((String)value) ? 1 : 0) != 0, (Object)"value must be provided");
        Properties connectionProperties = this.getConnectionProperties();
        if (connectionProperties == null) {
            connectionProperties = new Properties();
        }
        connectionProperties.setProperty(key, value);
        this.setConnectionProperties(connectionProperties);
    }
}

