/*
 * Decompiled with CFR 0.152.
 */
package org.cg.rooster;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.directory.api.util.Strings;
import org.cg.rooster.DataRepository;
import org.cg.rooster.core.Condition;
import org.cg.rooster.core.Query;
import org.cg.rooster.core.RowColumnMapper;
import org.cg.rooster.core.SqlGrammar;
import org.cg.rooster.core.TableDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.Persistable;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class JdbcDataRepository<T extends Persistable<ID>, ID extends Serializable>
implements DataRepository<T, ID> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDataRepository.class);
    private final TableDefinition tableDefinition;
    private final RowColumnMapper<T> rowColumnMapper;
    private final JdbcTemplate jdbcTemplate;
    private final SqlGrammar sqlGrammar;

    public static Object[] primaryKey(Object ... idValues) {
        return idValues;
    }

    public JdbcDataRepository(TableDefinition tableDefinition, RowColumnMapper<T> rowColumnMapper, DataSource dataSource, SqlGrammar sqlGrammar) {
        this(tableDefinition, rowColumnMapper, dataSource, sqlGrammar, true);
    }

    public JdbcDataRepository(TableDefinition tableDefinition, RowColumnMapper<T> rowColumnMapper, DataSource dataSource, SqlGrammar sqlGrammar, boolean lazyinit) {
        Preconditions.checkNotNull((Object)tableDefinition, (Object)"tableDefinition must be provided");
        Preconditions.checkNotNull(rowColumnMapper, (Object)"rowColumnMapper must be provided");
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource must be provided");
        Preconditions.checkNotNull((Object)sqlGrammar, (Object)"sqlGrammar must be provided");
        this.tableDefinition = tableDefinition;
        this.rowColumnMapper = rowColumnMapper;
        this.jdbcTemplate = new JdbcTemplate(dataSource, lazyinit);
        this.jdbcTemplate.setFetchSize(1000);
        this.sqlGrammar = sqlGrammar;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    protected TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    protected RowColumnMapper<T> getRowColumnMapper() {
        return this.rowColumnMapper;
    }

    protected SqlGrammar getSqlGrammar() {
        return this.sqlGrammar;
    }

    @Override
    public <S extends T> S save(S entity) {
        Preconditions.checkNotNull(entity, (Object)"entity must be provided");
        Preconditions.checkState((this.rowColumnMapper != null ? 1 : 0) != 0, (Object)"rowColumnMapper must be initiated");
        Preconditions.checkState((!this.tableDefinition.isReadonly() ? 1 : 0) != 0, (Object)"table is readonly");
        LinkedHashMap<String, Object> columns = this.rowColumnMapper.mapColumns(entity);
        LinkedHashMap<String, Object> dynamicColumns = this.rowColumnMapper.mapDynamicColumns(entity);
        Preconditions.checkState((columns != null && !columns.isEmpty() ? 1 : 0) != 0, (Object)"rowColumnMapper.mapColumns must be implemented");
        Preconditions.checkState((dynamicColumns != null ? 1 : 0) != 0, (Object)"rowColumnMapper.mapDynamicColumns cannot cannot return null");
        boolean isSucceed = this.upsert(this.sqlGrammar.save(this.tableDefinition, columns, dynamicColumns), ArrayUtils.addAll((Object[])columns.values().toArray(), (Object[])dynamicColumns.values().toArray()));
        if (isSucceed) {
            LOG.info(String.format("[save]entity saved: %s.", entity));
            return entity;
        }
        return null;
    }

    @Override
    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        Preconditions.checkNotNull(entities, (Object)"entities must be provided");
        Preconditions.checkState((this.rowColumnMapper != null ? 1 : 0) != 0, (Object)"rowColumnMapper must be initiated");
        Preconditions.checkState((!this.tableDefinition.isReadonly() ? 1 : 0) != 0, (Object)"table is readonly");
        ArrayList queryArgs = new ArrayList();
        Iterator<S> iter = entities.iterator();
        String createQuery = null;
        LinkedList<Object[]> batchArgs = new LinkedList<Object[]>();
        while (iter.hasNext()) {
            Persistable entity = (Persistable)iter.next();
            LinkedHashMap<String, Object> columns = this.rowColumnMapper.mapColumns(entity);
            LinkedHashMap<String, Object> dynamicColumns = this.rowColumnMapper.mapDynamicColumns(entity);
            Preconditions.checkState((columns != null && !columns.isEmpty() ? 1 : 0) != 0, (Object)"rowColumnMapper.mapColumns must be implemented");
            Preconditions.checkState((dynamicColumns != null ? 1 : 0) != 0, (Object)"rowColumnMapper.mapDynamicColumns cannot cannot return null");
            batchArgs.add(ArrayUtils.addAll((Object[])columns.values().toArray(), (Object[])dynamicColumns.values().toArray()));
            String currentQuery = this.sqlGrammar.save(this.tableDefinition, columns, dynamicColumns);
            Preconditions.checkState((!Strings.isEmpty((String)currentQuery) ? 1 : 0) != 0, (Object)"inconsistent row column mapping in batch");
            if (createQuery != null) {
                Preconditions.checkState((boolean)createQuery.equals(currentQuery), (Object)"inconsistent row column mapping in batch");
            }
            createQuery = currentQuery;
        }
        long start = System.currentTimeMillis();
        boolean isSucceed = this.upsertBatch(createQuery, batchArgs);
        long end = System.currentTimeMillis() - start;
        if (isSucceed) {
            LOG.info(String.format("[save]saved %s entities in %sms", queryArgs.size(), end));
            return entities;
        }
        List empty = Collections.emptyList();
        return empty;
    }

    @Override
    public boolean exists(ID id) {
        Preconditions.checkNotNull(id, (Object)"id must be provided");
        return this.get(id) != null;
    }

    @Override
    public long count() {
        LOG.info(String.format("[count]%s", this.tableDefinition.getTableName()));
        return (Long)this.getJdbcTemplate().queryForObject(this.sqlGrammar.count(this.tableDefinition), Long.class);
    }

    @Override
    public boolean delete(ID id) {
        Object[] objectArray;
        Preconditions.checkNotNull(id, (Object)"id must be provided");
        Preconditions.checkState((boolean)this.tableDefinition.isMutable(), (Object)"table is immutable");
        Preconditions.checkState((!this.tableDefinition.isReadonly() ? 1 : 0) != 0, (Object)"table is readonly");
        if (id instanceof Object[]) {
            objectArray = (Object[])id;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = id;
        }
        Object[] idColumns = objectArray;
        boolean isSucceed = this.upsert(this.sqlGrammar.delete(this.tableDefinition), idColumns);
        if (isSucceed) {
            LOG.info(String.format("[delete]deleted %s", id));
        }
        return isSucceed;
    }

    @Override
    public boolean delete(Iterable<ID> ids) {
        Preconditions.checkNotNull(ids, (Object)"ids must be provided");
        Preconditions.checkState((boolean)this.tableDefinition.isMutable(), (Object)"table is immutable");
        Preconditions.checkState((!this.tableDefinition.isReadonly() ? 1 : 0) != 0, (Object)"table is readonly");
        Iterator<ID> iter = ids.iterator();
        Preconditions.checkArgument((boolean)iter.hasNext(), (Object)"ids must be provided");
        LinkedList<Object[]> batchArgs = new LinkedList<Object[]>();
        while (iter.hasNext()) {
            Serializable id = (Serializable)iter.next();
            if (id instanceof Object[]) {
                batchArgs.add((Object[])id);
                continue;
            }
            batchArgs.add(new Object[]{id});
        }
        boolean isSucceed = this.upsertBatch(this.sqlGrammar.delete(this.tableDefinition), batchArgs);
        if (isSucceed) {
            LOG.info(String.format("[delete]%s entities deleted", batchArgs.size()));
        }
        return isSucceed;
    }

    @Override
    public T get(ID id) {
        Object[] objectArray;
        if (id instanceof Object[]) {
            objectArray = (Object[])id;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = id;
        }
        Object[] idColumns = objectArray;
        LOG.info(String.format("[get]id:%s", Arrays.toString(idColumns)));
        long start = System.currentTimeMillis();
        List entity = this.jdbcTemplate.query(this.sqlGrammar.selectById(this.tableDefinition, null, 5000L, 1, this.rowColumnMapper.mapDynamicColumnsType(), null), this.rowColumnMapper, idColumns);
        long end = System.currentTimeMillis() - start;
        LOG.info(String.format("[get]found in %sms", end));
        return (T)(entity.isEmpty() ? null : (Persistable)entity.get(0));
    }

    @Override
    public Iterable<T> findAll() {
        long start = System.currentTimeMillis();
        List result = this.getJdbcTemplate().query(this.sqlGrammar.selectById(this.tableDefinition, null, 5000L, -1, this.rowColumnMapper.mapDynamicColumnsType(), null), this.rowColumnMapper);
        long end = System.currentTimeMillis() - start;
        LOG.info(String.format("[findAll]limit:%s. found %s in %sms", 5000, result.size(), end));
        return result;
    }

    @Override
    public Iterable<T> find(Query query) {
        Preconditions.checkNotNull((Object)query, (Object)"query must be provided");
        long start = System.currentTimeMillis();
        List result = query.getConditions() == null || query.getConditions().isEmpty() ? this.getJdbcTemplate().query(this.sqlGrammar.selectById(this.tableDefinition, query.getSort(), query.getLimit().intValue(), -1, this.rowColumnMapper.mapDynamicColumnsType(), query.getColumnSelection()), this.rowColumnMapper) : this.getJdbcTemplate().query(this.sqlGrammar.selectByCondition(this.tableDefinition, query.getSort(), query.getLimit().intValue(), query.getConditions(), this.rowColumnMapper.mapDynamicColumnsType(), query.getColumnSelection()), this.rowColumnMapper, Condition.getParamsFromConditions(query.getConditions()));
        long end = System.currentTimeMillis() - start;
        LOG.info(String.format("[find]query: %s in %sms", query, end));
        return result;
    }

    @Override
    public Iterable<T> find(Iterable<ID> ids) {
        return this.find(ids, new Query(null, null, null, 5000));
    }

    @Override
    public Iterable<T> find(Iterable<ID> ids, Query query) {
        Preconditions.checkNotNull(ids, (Object)"ids must be provided");
        Preconditions.checkNotNull((Object)query, (Object)"query must be provided");
        if (query.getConditions() != null && !query.getConditions().isEmpty()) {
            LOG.warn("[find]conditions will be ignored when lookup by id list");
        }
        if (!ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        LinkedList<Serializable> idColumnValuesList = new LinkedList<Serializable>();
        int idSize = 0;
        for (Serializable id : ids) {
            List<Object> idList = id instanceof Object[] ? Arrays.asList((Object[])id) : Collections.singletonList(id);
            idColumnValuesList.addAll(idList);
            ++idSize;
        }
        Object[] idsArray = idColumnValuesList.toArray();
        long start = System.currentTimeMillis();
        List result = this.getJdbcTemplate().query(this.sqlGrammar.selectById(this.tableDefinition, query.getSort(), query.getLimit().intValue(), idSize, this.rowColumnMapper.mapDynamicColumnsType(), query.getColumnSelection()), this.rowColumnMapper, idsArray);
        long end = System.currentTimeMillis() - start;
        LOG.info(String.format("[find]ids:%s; query:%s; found %s in %sms", Arrays.toString(idsArray), query, result.size(), end));
        return result;
    }

    private boolean upsert(String preparedStatement, Object ... args) {
        try {
            this.getJdbcTemplate().update(preparedStatement, args);
            return true;
        }
        catch (DataAccessException e) {
            LOG.error("Error in upserting record");
            LOG.error(Throwables.getStackTraceAsString((Throwable)e));
            return false;
        }
    }

    private boolean upsertBatch(String preparedStatement, List<Object[]> args) {
        try {
            this.getJdbcTemplate().batchUpdate(preparedStatement, args);
            return true;
        }
        catch (DataAccessException e) {
            LOG.error("Error in upserting records");
            LOG.error(Throwables.getStackTraceAsString((Throwable)e));
            return false;
        }
    }
}

