/*
 * Decompiled with CFR 0.152.
 */
package org.cg.rooster.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TableDefinition {
    private final String tableName;
    private final List<String> primaryId;
    private final boolean isMutable;
    private final boolean isReadonly;

    public TableDefinition(String tableName, String ... primaryIdComponents) {
        this(false, tableName, false, primaryIdComponents);
    }

    public TableDefinition(boolean isReadonly, String tableName, String ... primaryIdComponents) {
        this(isReadonly, tableName, false, primaryIdComponents);
    }

    public TableDefinition(String tableName, boolean isMutable, String ... primaryIdComponents) {
        this(false, tableName, isMutable, primaryIdComponents);
    }

    public TableDefinition(boolean isReadonly, String tableName, boolean isMutable, String ... primaryIdComponents) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0, (Object)"tableName must be provided");
        Preconditions.checkArgument((primaryIdComponents.length > 0 ? 1 : 0) != 0, (Object)"primaryIdComponent must be provided");
        this.tableName = tableName;
        this.primaryId = Collections.unmodifiableList(Arrays.asList(primaryIdComponents));
        this.isMutable = isMutable;
        this.isReadonly = isReadonly;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getPrimaryId() {
        return this.primaryId;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    public boolean isReadonly() {
        return this.isReadonly;
    }

    public String toString() {
        return "TableDefinition [tableName=" + this.tableName + ", primaryId=" + this.primaryId + ", isMutable=" + this.isMutable + "]";
    }
}

