/*
 * Decompiled with CFR 0.152.
 */
package org.cg.rooster.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.LinkedList;
import java.util.List;
import org.cg.rooster.core.ConditionOperator;

public class Condition {
    private final Object lhsOperand;
    private final Object rhsOperand;
    private final ConditionOperator operator;
    public static final String SPACE = " ";
    public static final String PLACEHOLDER = " ?";

    public Condition(String columnName, ConditionOperator operator, Object value) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)columnName) ? 1 : 0) != 0, (Object)"operator must be provided");
        Preconditions.checkNotNull((Object)operator, (Object)"operator must be provided");
        this.lhsOperand = columnName;
        this.operator = operator;
        this.rhsOperand = value;
    }

    public Condition(Condition c1, ConditionOperator operator, Condition c2) {
        Preconditions.checkNotNull((Object)c1, (Object)"c1 must be provided");
        Preconditions.checkNotNull((Object)operator, (Object)"operator must be provided");
        Preconditions.checkNotNull((Object)c2, (Object)"c2 must be provided");
        this.lhsOperand = c1;
        this.operator = operator;
        this.rhsOperand = c2;
    }

    public Object getLhsOperand() {
        return this.lhsOperand;
    }

    public Object getRhsOperand() {
        return this.rhsOperand;
    }

    public ConditionOperator getOperator() {
        return this.operator;
    }

    public static String parseCondition(Condition conditon) {
        Preconditions.checkNotNull((Object)conditon, (Object)"condition must be provided");
        Object lhs = conditon.getLhsOperand();
        Object rhs = conditon.getRhsOperand();
        String op = conditon.getOperator().getOperatorSQLStr();
        if (lhs instanceof String) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append((String)lhs).append(SPACE).append(op);
            if (rhs != null) {
                sb.append(PLACEHOLDER);
            }
            sb.append(")");
            return sb.toString();
        }
        if (lhs instanceof Condition && rhs instanceof Condition) {
            return Condition.parseCondition((Condition)lhs).concat(SPACE).concat(op).concat(SPACE).concat(Condition.parseCondition((Condition)rhs));
        }
        throw new UnsupportedOperationException("Invalid operation for condition.");
    }

    public static Object[] getParamsFromConditions(List<Condition> conditions) {
        Preconditions.checkNotNull(conditions, (Object)"conditions must be provided");
        LinkedList<Object> params = new LinkedList<Object>();
        for (Condition c : conditions) {
            Condition.parseConditionParam(c, params);
        }
        return params.toArray();
    }

    private static void parseConditionParam(Condition c, List<Object> params) {
        Object lhs = c.getLhsOperand();
        Object rhs = c.getRhsOperand();
        if (lhs instanceof String) {
            if (rhs != null) {
                params.add(rhs);
            }
            return;
        }
        if (!(lhs instanceof Condition) || !(rhs instanceof Condition)) {
            throw new UnsupportedOperationException("Invalid operation for condition.");
        }
        Condition.parseConditionParam((Condition)lhs, params);
        Condition.parseConditionParam((Condition)rhs, params);
    }
}

