/*
 * Decompiled with CFR 0.152.
 */
package org.cg.rooster.core;

import com.google.common.base.Preconditions;
import java.util.List;
import org.cg.rooster.core.Condition;
import org.cg.rooster.core.Query;
import org.springframework.data.domain.Sort;

public class QueryBuilder {
    private List<String> columnSelection = null;
    private List<Condition> conditions = null;
    private Sort sort = null;
    private int limit = 5000;

    public static QueryBuilder newBuilder() {
        return new QueryBuilder();
    }

    public QueryBuilder conditions(List<Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public QueryBuilder sort(Sort sort) {
        this.sort = sort;
        return this;
    }

    public QueryBuilder limit(int limit) {
        Preconditions.checkArgument((limit > 0 && limit <= 5000 ? 1 : 0) != 0, (Object)"limit out of supported range");
        this.limit = limit;
        return this;
    }

    public Query build() {
        return new Query(this.columnSelection, this.conditions, this.sort, this.limit);
    }
}

