/*
 * Decompiled with CFR 0.152.
 */
package org.cg.rooster.phoenix;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cg.rooster.core.Condition;
import org.cg.rooster.core.SqlGrammar;
import org.cg.rooster.core.TableDefinition;
import org.springframework.data.domain.Sort;

public class PhoenixSqlGrammar
implements SqlGrammar {
    public static final String SELECT = "SELECT ";
    public static final String COUNT = "COUNT(*) ";
    public static final String ALL = "* ";
    public static final String FROM = "FROM ";
    public static final String WHERE = " WHERE ";
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    public static final String DELETE = "DELETE ";
    public static final String VALUES = " VALUES ";
    public static final String UPSERT = "UPSERT INTO ";
    public static final String COMMA = ", ";
    public static final String SPACE = " ";
    public static final String PLACEHOLDER = "?";
    public static final String PLACEHOLDER_COMMA = "?, ";
    public static final String EQUAL_PLACEHOLDER = " = ?";
    public static final String ORDER_BY = " ORDER BY ";
    public static final String LIMIT = " LIMIT ";
    public static final String INTEGER = "INTEGER";
    public static final String BIGINT = "BIGINT";
    public static final String TINYINT = "TINYINT";
    public static final String SMALLINT = "SMALLINT";
    public static final String FLOAT = "FLOAT";
    public static final String DOUBLE = "DOUBLE";
    public static final String DECIMAL = "DECIMAL";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String TIME = "TIME";
    public static final String DATE = "DATE";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String VARCHAR = "VARCHAR";
    public static final String CHAR = "CHAR";
    public static final String BINARY = "BINARY";
    public static final String VARBINARY = "VARBINARY";
    public static final String ARRAY = "ARRAY";
    private static PhoenixSqlGrammar singleton = new PhoenixSqlGrammar();

    private PhoenixSqlGrammar() {
    }

    public static PhoenixSqlGrammar getInstance() {
        return singleton;
    }

    @Override
    public String getParamDataType(Object arg) {
        if (arg instanceof Integer) {
            return INTEGER;
        }
        if (arg instanceof Long) {
            return BIGINT;
        }
        if (arg instanceof Byte) {
            return TINYINT;
        }
        if (arg instanceof Short) {
            return SMALLINT;
        }
        if (arg instanceof Float) {
            return FLOAT;
        }
        if (arg instanceof Double) {
            return DOUBLE;
        }
        if (arg instanceof BigDecimal) {
            return DECIMAL;
        }
        if (arg instanceof Boolean) {
            return BOOLEAN;
        }
        if (arg instanceof Time) {
            return TIME;
        }
        if (arg instanceof Date) {
            return DATE;
        }
        if (arg instanceof Timestamp) {
            return TIMESTAMP;
        }
        if (arg instanceof BigDecimal) {
            return DECIMAL;
        }
        if (arg instanceof String) {
            return VARCHAR;
        }
        if (arg instanceof byte[]) {
            return VARBINARY;
        }
        if (arg instanceof Array) {
            return ARRAY;
        }
        throw new UnsupportedOperationException("Data type unsupported.");
    }

    @Override
    public String count(TableDefinition table) {
        Preconditions.checkNotNull((Object)table, (Object)"table must be provided");
        return "SELECT COUNT(*) FROM " + table.getTableName();
    }

    @Override
    public String delete(TableDefinition table) {
        Preconditions.checkNotNull((Object)table, (Object)"table must be provided");
        String query = "DELETE FROM " + table.getTableName();
        return query + PhoenixSqlGrammar.whereByIdsClause(table, 1);
    }

    @Override
    public String selectById(TableDefinition table, Sort sort, long limit, int idSize, Map<String, String> dynamicColumnsType, List<String> columnSelectionList) {
        Preconditions.checkNotNull((Object)table, (Object)"table must be provided");
        String query = SELECT + PhoenixSqlGrammar.getColumnSelection(columnSelectionList) + FROM + table.getTableName();
        if (dynamicColumnsType != null && !dynamicColumnsType.isEmpty()) {
            query = query + PhoenixSqlGrammar.dynamicColumnsList(dynamicColumnsType);
        }
        if (idSize > 0) {
            query = query + PhoenixSqlGrammar.whereByIdsClause(table, idSize);
        }
        return query + PhoenixSqlGrammar.orderByClause(sort) + PhoenixSqlGrammar.limitClause(limit);
    }

    @Override
    public String selectByCondition(TableDefinition table, Sort sort, long limit, List<Condition> conditions, Map<String, String> dynamicColumnsType, List<String> columnSelectionList) {
        Preconditions.checkNotNull((Object)table, (Object)"table must be provided");
        Preconditions.checkNotNull(conditions, (Object)"conditions must be provided");
        String query = SELECT + PhoenixSqlGrammar.getColumnSelection(columnSelectionList) + FROM + table.getTableName();
        if (dynamicColumnsType != null && !dynamicColumnsType.isEmpty()) {
            query = query + PhoenixSqlGrammar.dynamicColumnsList(dynamicColumnsType);
        }
        if (conditions.size() > 0) {
            query = query + PhoenixSqlGrammar.whereByConditionClause(table, conditions);
        }
        return query + PhoenixSqlGrammar.orderByClause(sort) + PhoenixSqlGrammar.limitClause(limit);
    }

    @Override
    public String save(TableDefinition table, Map<String, Object> columnMapper, Map<String, Object> dynamicColumnMapper) {
        Map.Entry<String, Object> e;
        Preconditions.checkNotNull((Object)table, (Object)"table must be provided");
        Preconditions.checkNotNull(columnMapper, (Object)"columnMapper must be provided");
        Preconditions.checkNotNull(dynamicColumnMapper, (Object)"dynamicColumnMapper must be provided");
        StringBuilder sb = new StringBuilder(UPSERT + table.getTableName() + " (");
        Iterator<Map.Entry<String, Object>> iter = columnMapper.entrySet().iterator();
        while (iter.hasNext()) {
            e = iter.next();
            sb.append(e.getKey());
            if (!iter.hasNext()) continue;
            sb.append(COMMA);
        }
        iter = dynamicColumnMapper.entrySet().iterator();
        if (iter.hasNext()) {
            sb.append(COMMA);
        }
        while (iter.hasNext()) {
            e = iter.next();
            Preconditions.checkNotNull((Object)e.getValue(), (Object)"Dynamic column's value cannot be null");
            sb.append(e.getKey()).append(SPACE).append(this.getParamDataType(e.getValue()));
            if (!iter.hasNext()) continue;
            sb.append(COMMA);
        }
        sb.append(")").append(VALUES).append("(");
        int paramSize = columnMapper.size() + dynamicColumnMapper.size();
        for (int i = 0; i < paramSize; ++i) {
            sb.append(PLACEHOLDER);
            if (i >= paramSize - 1) continue;
            sb.append(COMMA);
        }
        return sb.append(")").toString();
    }

    private static String getColumnSelection(List<String> columnSelectionList) {
        String columnsSelection = ALL;
        if (columnSelectionList != null && !columnSelectionList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> iter = columnSelectionList.iterator();
            while (iter.hasNext()) {
                String column = iter.next();
                sb.append(column);
                if (iter.hasNext()) {
                    sb.append(COMMA);
                    continue;
                }
                sb.append(SPACE);
            }
            columnsSelection = sb.toString();
        }
        return columnsSelection;
    }

    private static String limitClause(long limit) {
        if (limit < 0L) {
            return " LIMIT 5000";
        }
        return LIMIT + limit;
    }

    private static String orderByClause(Sort sort) {
        if (sort == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ORDER_BY);
        Iterator iter = sort.iterator();
        while (iter.hasNext()) {
            Sort.Order order = (Sort.Order)iter.next();
            sb.append(order.getProperty()).append(SPACE).append(order.getDirection().toString());
            if (!iter.hasNext()) continue;
            sb.append(COMMA);
        }
        return sb.toString();
    }

    private static String whereByIdsClause(TableDefinition table, int idSize) {
        List<String> idComponents = table.getPrimaryId();
        StringBuilder sb = new StringBuilder(WHERE);
        for (int i = 0; i < idSize; ++i) {
            if (i > 0) {
                sb.append(OR);
            }
            sb.append("(");
            Iterator<String> iter = idComponents.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next()).append(EQUAL_PLACEHOLDER);
                if (iter.hasNext()) {
                    sb.append(AND);
                    continue;
                }
                sb.append(SPACE);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private static String whereByConditionClause(TableDefinition table, List<Condition> conditions) {
        StringBuilder sb = new StringBuilder(WHERE);
        for (int i = 0; i < conditions.size(); ++i) {
            if (i > 0) {
                sb.append(AND);
            }
            sb.append("(");
            sb.append(Condition.parseCondition(conditions.get(i)));
            sb.append(")");
        }
        return sb.toString();
    }

    private static String dynamicColumnsList(Map<String, String> dynamicColumnsType) {
        StringBuilder sb = new StringBuilder("(");
        Iterator<Map.Entry<String, String>> iter = dynamicColumnsType.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> e = iter.next();
            sb.append(e.getKey()).append(SPACE).append(e.getValue());
            if (!iter.hasNext()) continue;
            sb.append(COMMA);
        }
        sb.append(")");
        return sb.toString();
    }
}

