/*
 * Decompiled with CFR 0.152.
 */
package main.java.exporter;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HealthCheck {
    private final String name;
    private final String script;
    private final long updateInterval;
    private final long timeoutLimit;
    private long lastCheckTime;
    private int healthCheckResult;
    public static final Logger logger = LogManager.getLogger();

    public HealthCheck(String n, String s, String i, String t) {
        this.name = n;
        this.script = s;
        this.updateInterval = Integer.parseInt(i);
        this.timeoutLimit = Integer.parseInt(t);
        this.lastCheckTime = 0L;
        this.healthCheckResult = 1;
    }

    public String getName() {
        return this.name;
    }

    public synchronized int getResult() {
        logger.debug("current: " + System.currentTimeMillis());
        logger.debug("lastCheckTime " + this.lastCheckTime);
        logger.debug("diff: " + (System.currentTimeMillis() - this.lastCheckTime));
        logger.debug("updateInterval " + this.updateInterval);
        if (System.currentTimeMillis() - this.lastCheckTime > this.updateInterval * 1000L) {
            logger.info("Updating result of " + this.name);
            this.updateResult();
        }
        logger.info(this.name + "'s result is:" + this.healthCheckResult);
        return this.healthCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateResult() {
        File dir = null;
        try {
            dir = HealthCheck.createDirectory(this.name);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        Runtime currRuntime = Runtime.getRuntime();
        int exitStatus = 1;
        if (dir != null) {
            try {
                Process p = currRuntime.exec(this.script, null, dir);
                p.waitFor(this.timeoutLimit, TimeUnit.SECONDS);
                exitStatus = p.exitValue();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                HealthCheck.deleteDirectory(dir);
            }
        }
        this.lastCheckTime = System.currentTimeMillis();
        this.healthCheckResult = exitStatus;
    }

    private static File createDirectory(String context) throws InterruptedException {
        File directory = new File("/tmp/" + context + "/" + Long.toString(System.nanoTime()));
        if (directory.exists()) {
            Thread.sleep(2L);
            HealthCheck.createDirectory(context);
        }
        logger.info("try to creating:" + directory.getAbsolutePath());
        boolean successful = directory.mkdirs();
        if (successful) {
            return directory;
        }
        logger.error("Failed trying to create the tmp directory");
        return null;
    }

    private static boolean deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && null != (files = directory.listFiles())) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    HealthCheck.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return directory.delete();
    }
}

