/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.database;

import com.github.collinalpert.java2db.annotations.ForeignKeyObject;
import java.lang.reflect.Field;

public class TableNameColumn {
    private final String tableName;
    private final Field column;

    public TableNameColumn(String tableName, Field column) {
        this.tableName = tableName;
        this.column = column;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Field getColumn() {
        return this.column;
    }

    public String getSQLNotation() {
        return this.tableName + "." + this.column.getName();
    }

    public String getAliasNotation() {
        return this.tableName + "_" + this.column.getName();
    }

    public boolean isForeignKey() {
        return this.column.getAnnotation(ForeignKeyObject.class) != null;
    }

    public String toString() {
        return this.getSQLNotation();
    }
}

