/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.ConstantExpression;
import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionClassVisitor;
import com.trigersoft.jaque.expression.InvocableExpression;
import com.trigersoft.jaque.expression.InvocationExpression;
import com.trigersoft.jaque.expression.LambdaExpression;
import com.trigersoft.jaque.expression.MemberExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import com.trigersoft.jaque.expression.SerializedLambda;
import com.trigersoft.jaque.expression.SimpleExpressionVisitor;
import com.trigersoft.jaque.expression.TypeConverter;
import com.trigersoft.jaque.expression.UnaryExpression;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;

class ExpressionClassCracker {
    private static final String DUMP_FOLDER_SYSTEM_PROPERTY = "jdk.internal.lambda.dumpProxyClasses";
    private static final URLClassLoader lambdaClassLoader;
    private static final String lambdaClassLoaderCreationError;
    private static ExpressionClassCracker instance;

    public static ExpressionClassCracker get() {
        return instance;
    }

    private ExpressionClassCracker() {
    }

    LambdaExpression<?> lambda(Object lambda) {
        Class<?> lambdaClass = lambda.getClass();
        if (!lambdaClass.isSynthetic()) {
            throw new IllegalArgumentException("The requested object is not a Java lambda");
        }
        if (lambda instanceof Serializable) {
            SerializedLambda extracted = SerializedLambda.extractLambda((Serializable)lambda);
            ClassLoader lambdaClassLoader = lambdaClass.getClassLoader();
            return this.lambda(extracted, lambdaClassLoader);
        }
        ExpressionClassVisitor lambdaVisitor = this.parseFromFileSystem(lambda, lambdaClass);
        Expression lambdaExpression = lambdaVisitor.getResult();
        Class<?> lambdaType = lambdaVisitor.getType();
        ParameterExpression[] lambdaParams = lambdaVisitor.getParams();
        InvocationExpression target = (InvocationExpression)this.stripConvertExpressions(lambdaExpression);
        Method actualMethod = (Method)((MemberExpression)target.getTarget()).getMember();
        if (!actualMethod.isSynthetic()) {
            return Expression.lambda(lambdaType, target, Collections.unmodifiableList(Arrays.asList(lambdaParams)));
        }
        Class<?> actualClass = actualMethod.getDeclaringClass();
        ClassLoader actualClassLoader = actualClass.getClassLoader();
        String actualClassPath = this.classFilePath(actualClass.getName());
        ExpressionClassVisitor actualVisitor = this.parseClass(actualClassLoader, actualClassPath, () -> Expression.constant(lambda), actualMethod);
        Expression actualExpression = TypeConverter.convert(actualVisitor.getResult(), actualVisitor.getType());
        ParameterExpression[] actualParams = actualVisitor.getParams();
        return this.buildExpression(lambdaType, lambdaParams, target, actualVisitor, actualExpression, actualParams);
    }

    LambdaExpression<?> lambda(SerializedLambda extracted, ClassLoader lambdaClassLoader) {
        int boundArgs;
        int i;
        boolean hasCapturedArgs = extracted.capturedArgs != null && extracted.capturedArgs.length > 0;
        boolean[] hasThis = hasCapturedArgs ? new boolean[1] : null;
        ExpressionClassVisitor actualVisitor = this.parseClass(lambdaClassLoader, this.classFilePath(extracted.implClass), hasCapturedArgs ? () -> {
            hasThis[0] = true;
            Object instance = extracted.capturedArgs[0];
            return Expression.constant(instance);
        } : null, extracted.implMethodName, extracted.implMethodSignature);
        Expression reducedExpression = TypeConverter.convert(actualVisitor.getResult(), actualVisitor.getType());
        ParameterExpression[] params = actualVisitor.getParams();
        LambdaExpression extractedLambda = Expression.lambda(actualVisitor.getType(), reducedExpression, Collections.unmodifiableList(Arrays.asList(params)));
        if (!hasCapturedArgs) {
            return extractedLambda;
        }
        ArrayList<Expression> args = new ArrayList<Expression>(params.length);
        int capturedLength = extracted.capturedArgs.length;
        int n = i = hasThis != null && hasThis[0] ? 1 : 0;
        while (i < capturedLength) {
            LambdaExpression<?> arg = extracted.capturedArgs[i];
            if (arg instanceof SerializedLambda) {
                SerializedLambda argLambda = (SerializedLambda)((Object)arg);
                LambdaExpression<?> argExtractedLambda = this.lambda(argLambda, lambdaClassLoader);
                extractedLambda = (LambdaExpression)extractedLambda.accept(new ParameterReplacer(argExtractedLambda, args.size()));
                arg = argExtractedLambda;
            }
            args.add(Expression.constant(arg));
            ++i;
        }
        ArrayList<ParameterExpression> finalParams = new ArrayList<ParameterExpression>(params.length - capturedLength);
        for (int y = boundArgs = args.size(); y < params.length; ++y) {
            ParameterExpression param = params[y];
            ParameterExpression arg = Expression.parameter(param.getResultType(), y - boundArgs);
            args.add(arg);
            finalParams.add(arg);
        }
        InvocationExpression newTarget = Expression.invoke(extractedLambda, args);
        return Expression.lambda(actualVisitor.getType(), newTarget, Collections.unmodifiableList(finalParams));
    }

    private ExpressionClassVisitor parseFromFileSystem(Object lambda, Class<?> lambdaClass) {
        if (lambdaClassLoader == null) {
            throw new RuntimeException(lambdaClassLoaderCreationError);
        }
        String lambdaClassPath = this.lambdaClassFilePath(lambdaClass);
        Method lambdaMethod = this.findFunctionalMethod(lambdaClass);
        return this.parseClass(lambdaClassLoader, lambdaClassPath, () -> Expression.constant(lambda), lambdaMethod);
    }

    private String lambdaClassFilePath(Class<?> lambdaClass) {
        String lambdaClassName = lambdaClass.getName();
        String className = lambdaClassName.substring(0, lambdaClassName.lastIndexOf(47));
        return this.classFilePath(className);
    }

    private String classFilePath(String className) {
        return className.replace('.', '/') + ".class";
    }

    private Method findFunctionalMethod(Class<?> functionalClass) {
        for (Method m : functionalClass.getMethods()) {
            if (m.isDefault()) continue;
            return m;
        }
        throw new IllegalArgumentException("Not a lambda expression. No non-default method.");
    }

    private ExpressionClassVisitor parseClass(ClassLoader classLoader, String classFilePath, Supplier<ConstantExpression> instance, Method method) {
        return this.parseClass(classLoader, classFilePath, instance, method.getName(), Type.getMethodDescriptor(method));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExpressionClassVisitor parseClass(ClassLoader classLoader, String classFilePath, Supplier<ConstantExpression> instance, String method, String methodDescriptor) {
        ExpressionClassVisitor visitor = new ExpressionClassVisitor(classLoader, instance, method, methodDescriptor);
        try (InputStream classStream = this.getResourceAsStream(classLoader, classFilePath);){
            ClassReader reader = new ClassReader(classStream);
            reader.accept(visitor, 6);
            ExpressionClassVisitor expressionClassVisitor = visitor;
            return expressionClassVisitor;
        }
        catch (IOException e) {
            throw new RuntimeException("error parsing class file " + classFilePath, e);
        }
    }

    private InputStream getResourceAsStream(ClassLoader classLoader, String path) throws FileNotFoundException {
        InputStream stream = classLoader.getResourceAsStream(path);
        if (stream == null) {
            throw new FileNotFoundException(path);
        }
        return stream;
    }

    private Expression stripConvertExpressions(Expression expression) {
        while (expression.getExpressionType() == 8) {
            expression = ((UnaryExpression)expression).getFirst();
        }
        return expression;
    }

    private LambdaExpression<?> buildExpression(Class<?> lambdaType, ParameterExpression[] lambdaParams, InvocationExpression target, ExpressionClassVisitor actualVisitor, Expression actualExpression, ParameterExpression[] actualParams) {
        List<Expression> ntArgs = target.getArguments();
        if (ntArgs.size() <= actualParams.length && this.allArgumentsAreParameters(ntArgs)) {
            ArrayList<ParameterExpression> newInnerParams = new ArrayList<ParameterExpression>();
            for (ParameterExpression actualParam : actualParams) {
                ParameterExpression newInnerParam = (ParameterExpression)ntArgs.get(actualParam.getIndex());
                newInnerParams.add(newInnerParam);
            }
            Expression reducedExpression = TypeConverter.convert(actualExpression, lambdaType);
            return Expression.lambda(lambdaType, reducedExpression, Collections.unmodifiableList(newInnerParams));
        }
        LambdaExpression<?> inner = Expression.lambda(actualVisitor.getType(), actualExpression, Collections.unmodifiableList(Arrays.asList(actualParams)));
        InvocationExpression newTarget = Expression.invoke(inner, target.getArguments());
        return Expression.lambda(lambdaType, newTarget, Collections.unmodifiableList(Arrays.asList(lambdaParams)));
    }

    private boolean allArgumentsAreParameters(List<Expression> ntArgs) {
        for (Expression e : ntArgs) {
            if (e.getExpressionType() == 31) continue;
            return false;
        }
        return true;
    }

    static {
        instance = new ExpressionClassCracker();
        String folderPath = System.getProperty(DUMP_FOLDER_SYSTEM_PROPERTY);
        if (folderPath == null) {
            lambdaClassLoaderCreationError = "Ensure that the 'jdk.internal.lambda.dumpProxyClasses' system property is properly set.";
            lambdaClassLoader = null;
        } else {
            File folder = new File(folderPath);
            if (!folder.isDirectory()) {
                lambdaClassLoaderCreationError = "Ensure that the 'jdk.internal.lambda.dumpProxyClasses' system property is properly set (" + folderPath + " does not exist).";
                lambdaClassLoader = null;
            } else {
                URL folderURL;
                try {
                    folderURL = folder.toURI().toURL();
                }
                catch (MalformedURLException mue) {
                    throw new RuntimeException(mue);
                }
                lambdaClassLoaderCreationError = null;
                lambdaClassLoader = new URLClassLoader(new URL[]{folderURL});
            }
        }
    }

    private static final class ParameterReplacer
    extends SimpleExpressionVisitor {
        private List<Integer> paramIndices;
        private final LambdaExpression<?> target;

        public ParameterReplacer(LambdaExpression<?> target, int paramIndex) {
            this.target = target;
            this.paramIndices = Arrays.asList(paramIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Expression visit(InvocationExpression e) {
            if (this.paramIndices.isEmpty()) {
                return e;
            }
            List<Integer> paramIndices = this.paramIndices;
            try {
                InvocableExpression target = e.getTarget();
                Expression expr = null;
                if (target instanceof MemberExpression) {
                    expr = target.accept(this);
                }
                List<Expression> args = this.visitArguments(e.getArguments());
                if (expr == null) {
                    expr = target.accept(this);
                }
                if (args != e.getArguments() || expr != e.getTarget()) {
                    InvocationExpression invocationExpression = Expression.invoke((InvocableExpression)expr, args);
                    return invocationExpression;
                }
                InvocationExpression invocationExpression = e;
                return invocationExpression;
            }
            finally {
                this.paramIndices = paramIndices;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<Expression> visitArguments(List<Expression> original) {
            try {
                List<Expression> list = super.visitArguments(original);
                return list;
            }
            finally {
                List<Integer> paramIndices = this.paramIndices;
                ArrayList<Integer> newParamIndices = new ArrayList<Integer>();
                for (int i = 0; i < original.size(); ++i) {
                    ParameterExpression p;
                    Expression e = original.get(i);
                    if (e.getExpressionType() != 31 || !paramIndices.contains((p = (ParameterExpression)e).getIndex())) continue;
                    newParamIndices.add(i);
                }
                this.paramIndices = newParamIndices;
            }
        }

        @Override
        public Expression visit(MemberExpression e) {
            Expression instance = e.getInstance();
            if (instance.getExpressionType() == 31 && this.paramIndices.contains(((ParameterExpression)instance).getIndex())) {
                return this.target;
            }
            return super.visit(e);
        }
    }
}

