/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

public final class ExpressionType {
    public static final int Add = 0;
    public static final int BitwiseAnd = 1;
    public static final int LogicalAnd = 2;
    public static final int ArrayIndex = 3;
    public static final int ArrayLength = 4;
    public static final int Coalesce = 5;
    public static final int Conditional = 6;
    public static final int Constant = 7;
    public static final int Convert = 8;
    public static final int Divide = 9;
    public static final int Equal = 10;
    public static final int ExclusiveOr = 11;
    public static final int GreaterThan = 12;
    public static final int GreaterThanOrEqual = 13;
    public static final int Invoke = 14;
    public static final int IsNull = 15;
    public static final int Lambda = 16;
    public static final int LeftShift = 17;
    public static final int LessThan = 18;
    public static final int LessThanOrEqual = 19;
    public static final int FieldAccess = 20;
    public static final int MethodAccess = 21;
    public static final int Modulo = 22;
    public static final int Multiply = 23;
    public static final int Negate = 24;
    public static final int New = 25;
    public static final int BitwiseNot = 26;
    public static final int LogicalNot = 27;
    public static final int NotEqual = 28;
    public static final int BitwiseOr = 29;
    public static final int LogicalOr = 30;
    public static final int Parameter = 31;
    public static final int Quote = 32;
    public static final int RightShift = 33;
    public static final int Subtract = 34;
    public static final int InstanceOf = 35;
    public static final int MaxExpressionTypeValue = 35;

    private ExpressionType() {
    }

    public static String toString(int expressionType) {
        switch (expressionType) {
            case 0: {
                return "+";
            }
            case 1: {
                return "&";
            }
            case 2: {
                return "&&";
            }
            case 3: {
                return "[]";
            }
            case 4: {
                return "#";
            }
            case 5: {
                return "??";
            }
            case 6: {
                return "?";
            }
            case 9: {
                return "/";
            }
            case 10: {
                return "==";
            }
            case 11: {
                return "^";
            }
            case 12: {
                return ">";
            }
            case 13: {
                return ">=";
            }
            case 15: {
                return "(Is Null)";
            }
            case 17: {
                return "<<";
            }
            case 18: {
                return "<";
            }
            case 19: {
                return "<=";
            }
            case 22: {
                return "%";
            }
            case 23: {
                return "*";
            }
            case 24: {
                return "-";
            }
            case 26: {
                return "~";
            }
            case 27: {
                return "!";
            }
            case 28: {
                return "!=";
            }
            case 29: {
                return "|";
            }
            case 30: {
                return "||";
            }
            case 32: {
                return "";
            }
            case 33: {
                return ">>";
            }
            case 34: {
                return "-";
            }
            case 35: {
                return "instanceof";
            }
        }
        return Integer.toString(expressionType);
    }
}

