/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator.processing;

import com.github.containersolutions.operator.processing.retry.Retry;
import com.github.containersolutions.operator.processing.retry.RetryExecution;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.Watcher;
import java.util.Optional;

public class CustomResourceEvent {
    private final RetryExecution retryExecution;
    private final Watcher.Action action;
    private final CustomResource resource;
    private int retryCount = -1;

    CustomResourceEvent(Watcher.Action action, CustomResource resource, Retry retry) {
        this.action = action;
        this.resource = resource;
        this.retryExecution = retry.initExecution();
    }

    Watcher.Action getAction() {
        return this.action;
    }

    public CustomResource getResource() {
        return this.resource;
    }

    public String resourceUid() {
        return this.resource.getMetadata().getUid();
    }

    public Optional<Long> nextBackOff() {
        ++this.retryCount;
        return this.retryExecution.nextDelay();
    }

    public String toString() {
        return "CustomResourceEvent{action=" + (Object)((Object)this.action) + ", resource=[ name=" + this.resource.getMetadata().getName() + ", kind=" + this.resource.getKind() + ", apiVersion=" + this.resource.getApiVersion() + " ,resourceVersion=" + this.resource.getMetadata().getResourceVersion() + ", markedForDeletion: " + (this.resource.getMetadata().getDeletionTimestamp() != null && !this.resource.getMetadata().getDeletionTimestamp().isEmpty()) + " ], retriesIndex=" + this.retryCount + '}';
    }
}

