/*
 * Decompiled with CFR 0.152.
 */
package com.github.containersolutions.operator.sample;

import com.github.containersolutions.operator.api.Controller;
import com.github.containersolutions.operator.api.ResourceController;
import com.github.containersolutions.operator.sample.Schema;
import com.github.containersolutions.operator.sample.SchemaStatus;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller(crdName="schemas.mysql.sample.javaoperatorsdk", customResourceClass=Schema.class)
public class SchemaController
implements ResourceController<Schema> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Optional<Schema> createOrUpdateResource(Schema schema) {
        try {
            Connection connection = this.getConnection();
            ResultSet resultSet = connection.createStatement().executeQuery(String.format("SELECT schema_name FROM information_schema.schemata WHERE schema_name = \"%1$s\"", schema.getMetadata().getName()));
            if (!resultSet.first()) {
                connection.createStatement().execute(String.format("CREATE SCHEMA `%1$s` DEFAULT CHARACTER SET %2$s", schema.getMetadata().getName(), schema.getSpec().getEncoding()));
                SchemaStatus status = new SchemaStatus();
                status.setUrl(String.format("jdbc:mysql://%1$s/%2$s", System.getenv("MYSQL_HOST"), schema.getMetadata().getName()));
                status.setStatus("CREATED");
                schema.setStatus(status);
                this.log.info("Schema {} created", (Object)schema.getMetadata().getName());
                return Optional.of(schema);
            }
            return Optional.of(schema);
        }
        catch (SQLException e) {
            this.log.error("Error while creating Schema", e);
            SchemaStatus status = new SchemaStatus();
            status.setUrl(null);
            status.setStatus("ERROR");
            schema.setStatus(status);
            return Optional.of(schema);
        }
    }

    @Override
    public boolean deleteResource(Schema schema) {
        this.log.info("Execution deleteResource for: {}", (Object)schema.getMetadata().getName());
        try {
            Connection connection = this.getConnection();
            connection.createStatement().execute("DROP DATABASE `" + schema.getMetadata().getName() + "`");
            this.log.info("Deleted Schema '{}'", (Object)schema.getMetadata().getName());
            return true;
        }
        catch (SQLException e) {
            this.log.error("Error while trying to delete Schema", e);
            return false;
        }
    }

    private Connection getConnection() throws SQLException {
        return DriverManager.getConnection(String.format("jdbc:mysql://%1$s:%2$s?user=%3$s&password=%4$s", System.getenv("MYSQL_HOST"), System.getenv("MYSQL_PORT") != null ? System.getenv("MYSQL_PORT") : "3306", System.getenv("MYSQL_USER"), System.getenv("MYSQL_PASSWORD")));
    }
}

