/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.KubernetesResourceMappingProvider;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class KubernetesDeserializer
extends JsonDeserializer<KubernetesResource> {
    private static final String KIND = "kind";
    private static final String API_VERSION = "apiVersion";
    private static final String KEY_SEPARATOR = "#";
    private static final Map<String, Class<? extends KubernetesResource>> MAP = new ConcurrentHashMap<String, Class<? extends KubernetesResource>>();
    private static final String[] PACKAGES = new String[]{"io.fabric8.kubernetes.api.model.", "io.fabric8.kubernetes.api.model.admissionregistration.", "io.fabric8.kubernetes.api.model.apiextensions.", "io.fabric8.kubernetes.api.model.apps.", "io.fabric8.kubernetes.api.model.authentication.", "io.fabric8.kubernetes.api.model.authorization.", "io.fabric8.kubernetes.api.model.batch.", "io.fabric8.kubernetes.api.model.extensions.", "io.fabric8.kubernetes.api.model.networking.", "io.fabric8.kubernetes.api.model.policy.", "io.fabric8.kubernetes.api.model.rbac.", "io.fabric8.kubernetes.api.model.storage.", "io.fabric8.openshift.api.model."};

    @Override
    public KubernetesResource deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.readValueAsTree();
        if (node instanceof ObjectNode) {
            return KubernetesDeserializer.fromObjectNode(jp, (ObjectNode)node);
        }
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            Iterator<JsonNode> iterator = arrayNode.elements();
            ArrayList<HasMetadata> list = new ArrayList<HasMetadata>();
            while (iterator.hasNext()) {
                KubernetesResource resource;
                JsonNode jsonNode = iterator.next();
                if (!(jsonNode instanceof ObjectNode) || !((resource = KubernetesDeserializer.fromObjectNode(jp, (ObjectNode)jsonNode)) instanceof HasMetadata)) continue;
                list.add((HasMetadata)resource);
            }
            return ((KubernetesListBuilder)new KubernetesListBuilder().withItems(list)).build();
        }
        return null;
    }

    private static KubernetesResource fromObjectNode(JsonParser jp, ObjectNode node) throws IOException, JsonProcessingException {
        String key = KubernetesDeserializer.getKey(node);
        if (key != null) {
            Class resourceType = KubernetesDeserializer.getTypeForKey(key);
            if (resourceType == null) {
                throw JsonMappingException.from(jp, "No resource type found for:" + key);
            }
            return (KubernetesResource)jp.getCodec().treeToValue(node, resourceType);
        }
        return null;
    }

    private static String getKey(ObjectNode node) {
        JsonNode apiVersion = node.get(API_VERSION);
        JsonNode kind = node.get(KIND);
        return KubernetesDeserializer.getKey(apiVersion != null ? apiVersion.textValue() : null, kind != null ? kind.textValue() : null);
    }

    private static String getKey(String apiVersion, String kind) {
        if (kind == null) {
            return null;
        }
        if (apiVersion == null) {
            return kind;
        }
        return String.format("%s#%s", apiVersion, kind);
    }

    public static void registerCustomKind(String kind, Class<? extends KubernetesResource> clazz) {
        KubernetesDeserializer.registerCustomKind(null, kind, clazz);
    }

    public static void registerCustomKind(String apiVersion, String kind, Class<? extends KubernetesResource> clazz) {
        MAP.put(KubernetesDeserializer.getKey(apiVersion, kind), clazz);
    }

    private static Class getTypeForKey(String key) {
        Class result = MAP.get(key);
        if (result == null) {
            String name = key != null && key.contains(KEY_SEPARATOR) ? key.substring(key.indexOf(KEY_SEPARATOR) + 1) : key;
            result = KubernetesDeserializer.getInternalTypeForName(name);
        }
        if (result != null) {
            MAP.put(key, result);
        }
        return result;
    }

    private static Class getInternalTypeForName(String name) {
        for (String aPackage : PACKAGES) {
            Class result = KubernetesDeserializer.loadClassIfExists(aPackage + name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Class loadClassIfExists(String className) {
        try {
            return KubernetesDeserializer.class.getClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            return null;
        }
    }

    static {
        for (KubernetesResourceMappingProvider provider : ServiceLoader.load(KubernetesResourceMappingProvider.class)) {
            for (Map.Entry<String, Class<? extends KubernetesResource>> entry : provider.getMappings().entrySet()) {
                String key = entry.getKey();
                Class<? extends KubernetesResource> value = entry.getValue();
                if (!KubernetesResource.class.isAssignableFrom(value)) continue;
                MAP.put(key, value);
            }
        }
    }
}

