/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos;

import java.io.IOException;

public interface Func<X, Y> {
    public Y apply(X var1) throws Exception;

    public static final class NoNulls<X, Y>
    implements Func<X, Y> {
        private final Func<X, Y> func;

        public NoNulls(Func<X, Y> fnc) {
            this.func = fnc;
        }

        @Override
        public Y apply(X input) throws Exception {
            if (this.func == null) {
                throw new IllegalArgumentException("NULL instead of a valid function");
            }
            if (input == null) {
                throw new IllegalArgumentException("NULL instead of a valid input");
            }
            Y result = this.func.apply(input);
            if (result == null) {
                throw new IOException("NULL instead of a valid result");
            }
            return result;
        }
    }
}

