/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.bytes;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.cactoos.Bytes;
import org.cactoos.Text;
import org.cactoos.iterator.Mapped;
import org.cactoos.text.FormattedText;

public final class HexBytes
implements Bytes {
    private final Text origin;

    public HexBytes(Text origin) {
        this.origin = origin;
    }

    @Override
    public byte[] asBytes() throws Exception {
        String hex = this.origin.asString();
        if ((hex.length() & 1) == 1) {
            throw new IOException("Length of hexadecimal text is odd");
        }
        Mapped<Character, Integer> iter = new Mapped<Character, Integer>(c -> {
            int result = Character.digit(c.charValue(), 16);
            if (result == -1) {
                throw new IOException(new FormattedText("Unexpected character '%c'", c).asString());
            }
            return result;
        }, hex.chars().mapToObj(c -> Character.valueOf((char)c)).iterator());
        byte[] result = new byte[hex.length() / 2];
        for (int index = 0; index < hex.length(); index += 2) {
            try {
                int most = (Integer)iter.next();
                int less = (Integer)iter.next();
                result[index >>> 1] = (byte)((most << 4) + less);
                continue;
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        }
        return result;
    }
}

