/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.cactoos.collection.CollectionEnvelope;
import org.cactoos.collection.CollectionOf;
import org.cactoos.list.ListOf;

public final class Sorted<T>
extends CollectionEnvelope<T> {
    @SafeVarargs
    public Sorted(T ... src) {
        this(new ListOf<T>(src));
    }

    public Sorted(Iterable<T> src) {
        this((Comparator<T>)Comparator.naturalOrder(), new CollectionOf<T>(src));
    }

    @SafeVarargs
    public Sorted(Comparator<T> cmp, T ... src) {
        this(cmp, new CollectionOf<T>(src));
    }

    public Sorted(Comparator<T> cmp, Iterator<T> src) {
        this(cmp, new CollectionOf<T>(src));
    }

    public Sorted(Comparator<T> cmp, Iterable<T> src) {
        this(cmp, new CollectionOf<T>(src));
    }

    public Sorted(Comparator<T> cmp, Collection<T> src) {
        super(() -> {
            ArrayList items = new ArrayList(src.size());
            items.addAll(src);
            items.sort(cmp);
            return items;
        });
    }
}

