/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.func;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.cactoos.Func;
import org.cactoos.Proc;
import org.cactoos.func.FuncOf;

public final class AsyncFunc<X, Y>
implements Func<X, Future<Y>>,
Proc<X> {
    private final Func<X, Y> func;
    private final ExecutorService executor;

    public AsyncFunc(Proc<X> proc) {
        this(new FuncOf<X, Object>(proc, null));
    }

    public AsyncFunc(Func<X, Y> fnc) {
        this(fnc, Executors.defaultThreadFactory());
    }

    public AsyncFunc(Proc<X> proc, ThreadFactory fct) {
        this(new FuncOf<X, Object>(proc, null), fct);
    }

    public AsyncFunc(Func<X, Y> fnc, ThreadFactory fct) {
        this(fnc, Executors.newSingleThreadExecutor(fct));
    }

    public AsyncFunc(Proc<X> proc, ExecutorService exec) {
        this(new FuncOf<X, Object>(proc, null), exec);
    }

    public AsyncFunc(Func<X, Y> fnc, ExecutorService exec) {
        this.func = fnc;
        this.executor = exec;
    }

    @Override
    public Future<Y> apply(X input) {
        return this.executor.submit(() -> this.func.apply(input));
    }

    @Override
    public void exec(X input) {
        this.apply((Object)input);
    }
}

