/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.func;

import org.cactoos.Func;
import org.cactoos.Proc;
import org.cactoos.func.FuncOf;

public final class RepeatedFunc<X, Y>
implements Func<X, Y> {
    private final Func<X, Y> func;
    private final int times;

    public RepeatedFunc(Proc<X> proc, int max) {
        this(new FuncOf<X, Object>(proc, null), max);
    }

    public RepeatedFunc(Func<X, Y> fnc, int max) {
        this.func = fnc;
        this.times = max;
    }

    @Override
    public Y apply(X input) throws Exception {
        if (this.times <= 0) {
            throw new IllegalArgumentException("The number of repetitions must be at least 1");
        }
        Y result = null;
        for (int idx = 0; idx < this.times; ++idx) {
            result = this.func.apply(input);
        }
        return result;
    }
}

