/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.InputStream;
import org.cactoos.Input;
import org.cactoos.scalar.NumberEnvelope;

public final class LengthOf
extends NumberEnvelope {
    private static final long serialVersionUID = 512027185282287675L;

    public LengthOf(Input input) {
        this(input, 16384);
    }

    public LengthOf(Input input, int max) {
        super(() -> {
            if (max == 0) {
                throw new IllegalArgumentException("Cannot use a buffer limited to zero size");
            }
            try (InputStream stream = input.stream();){
                int len;
                byte[] buf = new byte[max];
                long length = 0L;
                do {
                    if ((len = stream.read(buf)) <= 0) continue;
                    length += (long)len;
                } while (len >= 0);
                Double d = length;
                return d;
            }
        });
    }
}

