/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cactoos.text.FormattedText;
import org.cactoos.text.UncheckedText;

public final class LoggingOutputStream
extends OutputStream {
    private final OutputStream origin;
    private final String destination;
    private final Logger logger;
    private final AtomicLong bytes;
    private final AtomicLong time;

    public LoggingOutputStream(OutputStream output, String dst) {
        this(output, dst, Logger.getLogger(dst));
    }

    public LoggingOutputStream(OutputStream output, String dst, Logger lgr) {
        this.origin = output;
        this.destination = dst;
        this.logger = lgr;
        this.bytes = new AtomicLong();
        this.time = new AtomicLong();
    }

    @Override
    public void write(int data) throws IOException {
        byte[] buf = new byte[]{(byte)data};
        this.write(buf, 0, 1);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int offset, int len) throws IOException {
        Instant start = Instant.now();
        this.origin.write(buf, offset, len);
        Instant end = Instant.now();
        long millis = Duration.between(start, end).toMillis();
        this.bytes.getAndAdd(len);
        this.time.getAndAdd(millis);
        Level level = this.logger.getLevel();
        if (!level.equals(Level.INFO)) {
            this.logger.log(level, new UncheckedText(new FormattedText("Written %d byte(s) to %s in %dms.", this.bytes.get(), this.destination, this.time.get())).asString());
        }
    }

    @Override
    public void close() throws IOException {
        this.origin.close();
        Level level = this.logger.getLevel();
        if (level.equals(Level.INFO)) {
            this.logger.log(level, new UncheckedText(new FormattedText("Written %d byte(s) to %s in %dms.", this.bytes.get(), this.destination, this.time.get())).asString());
        }
        this.logger.log(level, new UncheckedText(new FormattedText("Closed output stream from %s.", this.destination)).asString());
    }

    @Override
    public void flush() throws IOException {
        this.origin.flush();
        Level level = this.logger.getLevel();
        if (level.equals(Level.INFO)) {
            this.logger.log(level, new UncheckedText(new FormattedText("Written %d byte(s) to %s in %dms.", this.bytes.get(), this.destination, this.time.get())).asString());
        }
        this.logger.log(level, new UncheckedText(new FormattedText("Flushed output stream from %s.", this.destination)).asString());
    }
}

