/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.cactoos.Bytes;
import org.cactoos.Input;
import org.cactoos.Scalar;
import org.cactoos.Text;
import org.cactoos.io.InputOf;
import org.cactoos.scalar.StickyScalar;
import org.cactoos.scalar.UncheckedScalar;

public final class ReaderOf
extends Reader {
    private final UncheckedScalar<Reader> source;

    public ReaderOf(char ... chars) {
        this(new InputOf(chars));
    }

    public ReaderOf(char[] chars, Charset charset) {
        this(new InputOf(chars, charset));
    }

    public ReaderOf(char[] chars, CharSequence charset) {
        this(new InputOf(chars, charset));
    }

    public ReaderOf(byte[] bytes) {
        this(new InputOf(bytes));
    }

    public ReaderOf(byte[] bytes, Charset charset) {
        this((Input)new InputOf(bytes), charset);
    }

    public ReaderOf(byte[] bytes, CharSequence charset) {
        this((Input)new InputOf(bytes), charset);
    }

    public ReaderOf(Path path) {
        this(new InputOf(path));
    }

    public ReaderOf(File file) {
        this(new InputOf(file));
    }

    public ReaderOf(URL url) {
        this(new InputOf(url));
    }

    public ReaderOf(URI uri) {
        this(new InputOf(uri));
    }

    public ReaderOf(Bytes bytes) {
        this(new InputOf(bytes));
    }

    public ReaderOf(Text text) {
        this(new InputOf(text));
    }

    public ReaderOf(Text text, Charset charset) {
        this(new InputOf(text, charset));
    }

    public ReaderOf(Text text, CharSequence charset) {
        this(new InputOf(text, charset));
    }

    public ReaderOf(CharSequence text) {
        this(new InputOf(text));
    }

    public ReaderOf(CharSequence text, Charset charset) {
        this(new InputOf(text, charset));
    }

    public ReaderOf(CharSequence text, CharSequence charset) {
        this(new InputOf(text, charset));
    }

    public ReaderOf(Input input) {
        this(input, StandardCharsets.UTF_8);
    }

    public ReaderOf(Input input, Charset charset) {
        this(() -> new InputStreamReader(input.stream(), charset));
    }

    public ReaderOf(Input input, CharSequence charset) {
        this(() -> new InputStreamReader(input.stream(), charset.toString()));
    }

    public ReaderOf(Input input, CharsetDecoder decoder) {
        this(() -> new InputStreamReader(input.stream(), decoder));
    }

    public ReaderOf(InputStream stream) {
        this(stream, StandardCharsets.UTF_8);
    }

    public ReaderOf(InputStream stream, Charset charset) {
        this(new InputStreamReader(stream, charset));
    }

    public ReaderOf(InputStream stream, CharSequence charset) throws UnsupportedEncodingException {
        this(new InputStreamReader(stream, charset.toString()));
    }

    public ReaderOf(InputStream stream, CharsetDecoder decoder) {
        this(new InputStreamReader(stream, decoder));
    }

    private ReaderOf(Reader rdr) {
        this(() -> rdr);
    }

    private ReaderOf(Scalar<Reader> src) {
        this.source = new UncheckedScalar<Reader>(new StickyScalar<Reader>(src));
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.source.value().read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.source.value().close();
    }
}

