/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.io;

import org.cactoos.Bytes;
import org.cactoos.Func;
import org.cactoos.func.UncheckedFunc;

public final class UncheckedBytes
implements Bytes {
    private final Bytes bytes;
    private final Func<Exception, byte[]> fallback;

    public UncheckedBytes(Bytes bts) {
        this(bts, error -> {
            throw new RuntimeException((Throwable)error);
        });
    }

    public UncheckedBytes(Bytes bts, Func<Exception, byte[]> fbk) {
        this.bytes = bts;
        this.fallback = fbk;
    }

    @Override
    public byte[] asBytes() {
        byte[] data;
        try {
            data = this.bytes.asBytes();
        }
        catch (Exception ex) {
            data = new UncheckedFunc<Exception, byte[]>(this.fallback).apply(ex);
        }
        return data;
    }
}

