/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Cycled<T>
implements Iterator<T> {
    private final Iterable<T> origin;
    private Iterator<T> iterator;

    public Cycled(Iterable<T> iterable) {
        this.origin = iterable;
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = this.origin.iterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("The iterator doesn't have any more items");
        }
        return this.iterator.next();
    }
}

