/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.cactoos.text.FormattedText;
import org.cactoos.text.UncheckedText;

public final class IteratorNoNulls<X>
implements Iterator<X> {
    private final Iterator<X> iterator;
    private final AtomicLong pos;

    public IteratorNoNulls(Iterator<X> src) {
        this.iterator = src;
        this.pos = new AtomicLong();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public X next() {
        X next = this.iterator.next();
        if (next == null) {
            throw new IllegalStateException(new UncheckedText(new FormattedText("Item #%d of %s is NULL", this.pos.get(), this.iterator)).asString());
        }
        this.pos.incrementAndGet();
        return next;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

