/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public final class Partitioned<T>
implements Iterator<List<T>> {
    private final Iterator<T> decorated;
    private final int size;

    public Partitioned(int sze, Iterator<T> src) {
        this.size = sze;
        this.decorated = src;
    }

    @Override
    public boolean hasNext() {
        return this.decorated.hasNext();
    }

    @Override
    public List<T> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No partition left.");
        }
        if (this.size < 1) {
            throw new IllegalArgumentException("Partition size < 1");
        }
        LinkedList<T> result = new LinkedList<T>();
        for (int count = 0; count < this.size && this.hasNext(); ++count) {
            result.add(this.decorated.next());
        }
        return Collections.unmodifiableList(result);
    }
}

