/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cactoos.Scalar;
import org.cactoos.scalar.UncheckedScalar;

public final class Repeated<T>
implements Iterator<T> {
    private final UncheckedScalar<T> elm;
    private int repeat;

    public Repeated(int max, T element) {
        this(max, () -> element);
    }

    public Repeated(int max, Scalar<T> scalar) {
        this(max, new UncheckedScalar<T>(scalar));
    }

    public Repeated(int max, UncheckedScalar<T> scalar) {
        this.elm = scalar;
        this.repeat = max;
    }

    @Override
    public boolean hasNext() {
        return this.repeat > 0;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("The iterator can't repeat anymore.");
        }
        --this.repeat;
        return this.elm.value();
    }
}

