/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Skipped<T>
implements Iterator<T> {
    private final Iterator<T> origin;
    private int skip;

    public Skipped(Iterator<T> iterator, int skp) {
        this.origin = iterator;
        this.skip = skp;
    }

    @Override
    public boolean hasNext() {
        this.omit();
        return this.origin.hasNext();
    }

    @Override
    public T next() {
        this.omit();
        if (!this.hasNext()) {
            throw new NoSuchElementException("The iterator doesn't have items any more");
        }
        return this.origin.next();
    }

    private void omit() {
        while (this.skip > 0 && this.origin.hasNext()) {
            this.origin.next();
            --this.skip;
        }
    }
}

