/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.time;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.cactoos.text.TextEnvelope;
import org.cactoos.time.Iso;

public final class LocalDateAsText
extends TextEnvelope {
    public LocalDateAsText(LocalDate date) {
        this(date, new Iso().get());
    }

    public LocalDateAsText(LocalDate date, String format) {
        this(date, format, Locale.getDefault(Locale.Category.FORMAT));
    }

    public LocalDateAsText(LocalDate date, String format, Locale locale) {
        this(date, DateTimeFormatter.ofPattern(format, locale));
    }

    public LocalDateAsText(LocalDate date, DateTimeFormatter formatter) {
        super(() -> formatter.format(ZonedDateTime.of(date, LocalTime.MIN, ZoneId.systemDefault())));
    }
}

