/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.time;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.cactoos.text.TextEnvelope;
import org.cactoos.time.Iso;

public final class ZonedDateTimeAsText
extends TextEnvelope {
    public ZonedDateTimeAsText(ZonedDateTime date) {
        this(date, new Iso().get());
    }

    public ZonedDateTimeAsText(ZonedDateTime date, String format) {
        this(date, format, Locale.getDefault(Locale.Category.FORMAT));
    }

    public ZonedDateTimeAsText(ZonedDateTime date, String format, Locale locale) {
        this(date, DateTimeFormatter.ofPattern(format, locale));
    }

    public ZonedDateTimeAsText(ZonedDateTime date, DateTimeFormatter formatter) {
        super(() -> formatter.format(date));
    }
}

