/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.takes.Request;
import org.takes.Response;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.Pass;
import org.takes.facets.auth.codecs.Codec;
import org.takes.facets.cookies.RqCookies;
import org.takes.facets.cookies.RsWithCookie;
import org.takes.misc.Expires;
import org.takes.misc.Opt;
import org.takes.misc.Utf8String;

public final class PsCookie
implements Pass {
    private final Codec codec;
    private final String cookie;
    private final long age;

    public PsCookie(Codec cdc) {
        this(cdc, PsCookie.class.getSimpleName());
    }

    public PsCookie(Codec cdc, String name) {
        this(cdc, name, 30L);
    }

    public PsCookie(Codec cdc, String name, long days) {
        this.codec = cdc;
        this.cookie = name;
        this.age = days;
    }

    @Override
    public Opt<Identity> enter(Request req) throws IOException {
        Iterator<String> cookies = new RqCookies.Base(req).cookie(this.cookie).iterator();
        Opt<Identity> user = new Opt.Empty<Identity>();
        if (cookies.hasNext()) {
            user = new Opt.Single<Identity>(this.codec.decode(new Utf8String(cookies.next()).asBytes()));
        }
        return user;
    }

    @Override
    public Response exit(Response res, Identity idt) throws IOException {
        String text = idt.equals(Identity.ANONYMOUS) ? "" : new Utf8String(this.codec.encode(idt)).asString();
        return new RsWithCookie(res, (CharSequence)this.cookie, (CharSequence)text, "Path=/", "HttpOnly", new Expires.Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(this.age)).print());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsCookie)) {
            return false;
        }
        PsCookie other = (PsCookie)o;
        Codec this$codec = this.codec;
        Codec other$codec = other.codec;
        if (this$codec == null ? other$codec != null : !this$codec.equals(other$codec)) {
            return false;
        }
        String this$cookie = this.cookie;
        String other$cookie = other.cookie;
        if (this$cookie == null ? other$cookie != null : !this$cookie.equals(other$cookie)) {
            return false;
        }
        return this.age == other.age;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Codec $codec = this.codec;
        result = result * 59 + ($codec == null ? 43 : $codec.hashCode());
        String $cookie = this.cookie;
        result = result * 59 + ($cookie == null ? 43 : $cookie.hashCode());
        long $age = this.age;
        result = result * 59 + (int)($age >>> 32 ^ $age);
        return result;
    }
}

