/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth;

import java.io.IOException;
import java.util.Iterator;
import org.takes.Request;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.TkAuth;
import org.takes.facets.auth.codecs.CcPlain;
import org.takes.misc.Utf8String;
import org.takes.rq.RqHeaders;
import org.takes.rq.RqWrap;

public final class RqAuth
extends RqWrap {
    private final String header;

    public RqAuth(Request request) {
        this(request, TkAuth.class.getSimpleName());
    }

    public RqAuth(Request request, String hdr) {
        super(request);
        this.header = hdr;
    }

    public Identity identity() throws IOException {
        Iterator<String> headers = new RqHeaders.Base(this).header(this.header).iterator();
        Identity user = headers.hasNext() ? new CcPlain().decode(new Utf8String(headers.next()).asBytes()) : Identity.ANONYMOUS;
        return user;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RqAuth)) {
            return false;
        }
        RqAuth other = (RqAuth)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$header = this.header;
        String other$header = other.header;
        return !(this$header == null ? other$header != null : !this$header.equals(other$header));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RqAuth;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $header = this.header;
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        return result;
    }
}

