/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth;

import java.io.IOException;
import org.takes.Request;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.TkAuth;
import org.takes.facets.auth.codecs.CcPlain;
import org.takes.misc.Utf8String;
import org.takes.rq.RqFake;
import org.takes.rq.RqWithHeader;
import org.takes.rq.RqWrap;

public final class RqWithAuth
extends RqWrap {
    public RqWithAuth(String urn) throws IOException {
        this(new Identity.Simple(urn));
    }

    public RqWithAuth(Identity identity) throws IOException {
        this(identity, (Request)new RqFake());
    }

    public RqWithAuth(String urn, Request req) throws IOException {
        this(new Identity.Simple(urn), req);
    }

    public RqWithAuth(Identity identity, Request req) throws IOException {
        this(identity, TkAuth.class.getSimpleName(), req);
    }

    public RqWithAuth(Identity identity, String header, Request req) throws IOException {
        super(RqWithAuth.make(identity, header, req));
    }

    private static Request make(Identity identity, String header, Request req) throws IOException {
        return new RqWithHeader(req, header, new Utf8String(new CcPlain().encode(identity)).asString());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RqWithAuth)) {
            return false;
        }
        RqWithAuth other = (RqWithAuth)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RqWithAuth;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

