/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth;

import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.Pass;
import org.takes.facets.auth.RqWithAuth;
import org.takes.misc.Opt;
import org.takes.rq.RqWithoutHeader;
import org.takes.rq.RqWrap;

public final class TkAuth
implements Take {
    private final Take origin;
    private final Pass pass;
    private final String header;

    public TkAuth(Take take, Pass pss) {
        this(take, pss, TkAuth.class.getSimpleName());
    }

    public TkAuth(Take take, Pass pss, String hdr) {
        this.origin = take;
        this.pass = pss;
        this.header = hdr;
    }

    @Override
    public Response act(Request request) throws Exception {
        Opt<Identity> user = this.pass.enter(request);
        Response response = user.has() ? this.act(request, user.get()) : this.origin.act(request);
        return response;
    }

    private Response act(Request req, Identity identity) throws Exception {
        RqWrap wrap = new RqWithoutHeader(req, this.header);
        if (!identity.equals(Identity.ANONYMOUS)) {
            wrap = new RqWithAuth(identity, this.header, wrap);
        }
        return this.pass.exit(this.origin.act(wrap), identity);
    }

    public String toString() {
        return "TkAuth(origin=" + this.origin + ", pass=" + this.pass + ", header=" + this.header + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TkAuth)) {
            return false;
        }
        TkAuth other = (TkAuth)o;
        Take this$origin = this.origin;
        Take other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        Pass this$pass = this.pass;
        Pass other$pass = other.pass;
        if (this$pass == null ? other$pass != null : !this$pass.equals(other$pass)) {
            return false;
        }
        String this$header = this.header;
        String other$header = other.header;
        return !(this$header == null ? other$header != null : !this$header.equals(other$header));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Take $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        Pass $pass = this.pass;
        result = result * 59 + ($pass == null ? 43 : $pass.hashCode());
        String $header = this.header;
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        return result;
    }
}

