/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.codecs;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.codecs.Codec;
import org.takes.facets.auth.codecs.DecodingException;

public final class CcAes
implements Codec {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final int BLOCK = 16;
    private final Codec origin;
    private final Key key;
    private final SecureRandom random;

    public CcAes(Codec codec, String key) {
        this(codec, key.getBytes(Charset.defaultCharset()));
    }

    public CcAes(Codec codec, byte[] key) {
        this(codec, RANDOM, new SecretKeySpec(CcAes.withCorrectBlockSize((byte[])key.clone()), "AES"));
    }

    public CcAes(Codec codec, SecureRandom random, Key key) {
        this.origin = codec;
        this.key = key;
        this.random = random;
    }

    @Override
    public byte[] encode(Identity identity) throws IOException {
        return this.encrypt(this.origin.encode(identity));
    }

    @Override
    public Identity decode(byte[] bytes) throws IOException {
        return this.origin.decode(this.decrypt(bytes));
    }

    private byte[] encrypt(byte[] bytes) throws IOException {
        try {
            byte[] vector = new byte[16];
            this.random.nextBytes(vector);
            byte[] message = this.cipher(1, new IvParameterSpec(vector)).doFinal(bytes);
            byte[] res = new byte[vector.length + message.length];
            System.arraycopy(vector, 0, res, 0, vector.length);
            System.arraycopy(message, 0, res, vector.length, message.length);
            return res;
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            throw new IOException(ex);
        }
    }

    private static byte[] withCorrectBlockSize(byte[] key) {
        if (key.length != 16) {
            throw new IllegalArgumentException(String.format("the length of the AES key must be exactly %d bytes", 16));
        }
        return key;
    }

    private byte[] decrypt(byte[] bytes) throws IOException {
        if (bytes.length < 32) {
            throw new DecodingException("Invalid encrypted message format");
        }
        try {
            byte[] vector = new byte[16];
            byte[] message = new byte[bytes.length - vector.length];
            System.arraycopy(bytes, 0, vector, 0, vector.length);
            System.arraycopy(bytes, vector.length, message, 0, message.length);
            return this.cipher(2, new IvParameterSpec(vector)).doFinal(message);
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            throw new DecodingException(ex);
        }
    }

    private Cipher cipher(int mode, AlgorithmParameterSpec spec) throws IOException {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(mode, this.key, spec, this.random);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException ex) {
            throw new IOException(ex);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CcAes)) {
            return false;
        }
        CcAes other = (CcAes)o;
        Codec this$origin = this.origin;
        Codec other$origin = other.origin;
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        Key this$key = this.key;
        Key other$key = other.key;
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        SecureRandom this$random = this.random;
        SecureRandom other$random = other.random;
        return !(this$random == null ? other$random != null : !this$random.equals(other$random));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Codec $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        Key $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        SecureRandom $random = this.random;
        result = result * 59 + ($random == null ? 43 : $random.hashCode());
        return result;
    }
}

