/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.codecs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.codecs.Codec;
import org.takes.facets.auth.codecs.DecodingException;

public final class CcCompact
implements Codec {
    @Override
    public byte[] encode(Identity identity) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try (DataOutputStream stream = new DataOutputStream(data);){
            stream.writeUTF(identity.urn());
            for (Map.Entry<String, String> ent : identity.properties().entrySet()) {
                stream.writeUTF(ent.getKey());
                stream.writeUTF(ent.getValue());
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        return data.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Identity decode(byte[] bytes) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>(0);
        try (DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));){
            String urn = stream.readUTF();
            while (stream.available() > 0) {
                map.put(stream.readUTF(), stream.readUTF());
            }
            Identity.Simple simple = new Identity.Simple(urn, map);
            return simple;
        }
        catch (IOException ex) {
            throw new DecodingException(ex);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof CcCompact;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

