/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.codecs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.codecs.Codec;

public final class CcGzip
implements Codec {
    private final Codec origin;

    public CcGzip(Codec codec) {
        this.origin = codec;
    }

    @Override
    public byte[] encode(Identity identity) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
            gzip.write(this.origin.encode(identity));
        }
        return out.toByteArray();
    }

    @Override
    public Identity decode(byte[] bytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(bytes));){
            int data;
            while ((data = ((InputStream)gzip).read()) >= 0) {
                out.write(data);
            }
        }
        return this.origin.decode(out.toByteArray());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CcGzip)) {
            return false;
        }
        CcGzip other = (CcGzip)o;
        Codec this$origin = this.origin;
        Codec other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Codec $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

