/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.codecs;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.cactoos.Text;
import org.cactoos.list.ListOf;
import org.cactoos.text.SplitText;
import org.cactoos.text.UncheckedText;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.codecs.Codec;
import org.takes.facets.auth.codecs.DecodingException;
import org.takes.misc.Utf8String;

public final class CcPlain
implements Codec {
    @Override
    public byte[] encode(Identity identity) throws IOException {
        String encoding = Charset.defaultCharset().name();
        StringBuilder text = new StringBuilder(URLEncoder.encode(identity.urn(), encoding));
        for (Map.Entry<String, String> ent : identity.properties().entrySet()) {
            text.append(';').append(ent.getKey()).append('=').append(URLEncoder.encode(ent.getValue(), encoding));
        }
        return new Utf8String(text.toString()).asBytes();
    }

    @Override
    public Identity decode(byte[] bytes) throws IOException {
        ListOf<Text> parts = new ListOf<Text>(new SplitText((Text)new Utf8String(bytes), ";"));
        HashMap<String, String> map = new HashMap<String, String>(parts.size());
        for (int idx = 1; idx < parts.size(); ++idx) {
            ListOf<Text> pair = new ListOf<Text>(new SplitText((Text)parts.get(idx), "="));
            try {
                map.put(new UncheckedText((Text)pair.get(0)).asString(), CcPlain.decode(new UncheckedText((Text)pair.get(1)).asString()));
                continue;
            }
            catch (IllegalArgumentException ex) {
                throw new DecodingException(ex);
            }
        }
        return new Identity.Simple(CcPlain.decode(new UncheckedText((Text)parts.get(0)).asString()), map);
    }

    private static String decode(String text) throws UnsupportedEncodingException {
        try {
            return URLDecoder.decode(text, Charset.defaultCharset().name());
        }
        catch (IllegalArgumentException ex) {
            throw new DecodingException(ex);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof CcPlain;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

