/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.codecs;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.codecs.Codec;

public final class CcSigned
implements Codec {
    private final Codec cdc;
    private final String alg;
    private final Key key;

    public CcSigned(Codec origin, String algorithm, Key secret) {
        this.cdc = origin;
        this.alg = algorithm;
        this.key = secret;
    }

    @Override
    public byte[] encode(Identity identity) throws IOException {
        byte[] encoded = this.cdc.encode(identity);
        byte[] signature = this.mac().doFinal(encoded);
        byte[] signed = new byte[encoded.length + signature.length];
        System.arraycopy(encoded, 0, signed, 0, encoded.length);
        System.arraycopy(signature, 0, signed, encoded.length, signature.length);
        return signed;
    }

    @Override
    public Identity decode(byte[] bytes) throws IOException {
        Mac mac = this.mac();
        if (bytes.length < mac.getMacLength()) {
            throw new IOException("Invalid data size");
        }
        byte[] signature = new byte[mac.getMacLength()];
        byte[] encoded = new byte[bytes.length - signature.length];
        System.arraycopy(bytes, 0, encoded, 0, encoded.length);
        System.arraycopy(bytes, encoded.length, signature, 0, signature.length);
        byte[] actual = mac.doFinal(encoded);
        if (!Arrays.equals(actual, signature)) {
            throw new IOException("Bad signature");
        }
        return this.cdc.decode(encoded);
    }

    private Mac mac() throws IOException {
        try {
            Mac mac = Mac.getInstance(this.alg);
            mac.init(this.key);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException err) {
            throw new IOException(err);
        }
    }
}

