/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.auth.social;

import com.jcabi.http.request.JdkRequest;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.json.JsonObject;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.Response;
import org.takes.facets.auth.Identity;
import org.takes.facets.auth.Pass;
import org.takes.misc.Href;
import org.takes.misc.Opt;
import org.takes.rq.RqHref;

public final class PsGoogle
implements Pass {
    private static final String ERROR = "error";
    private static final String PICTURE = "picture";
    private static final String DISPLAY_NAME = "displayName";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String NAME = "name";
    private static final String CODE = "code";
    private final String app;
    private final String key;
    private final String redir;
    private final String gauth;
    private final String gapi;

    public PsGoogle(String gapp, String gkey, String uri) {
        this(gapp, gkey, uri, "https://accounts.google.com", "https://www.googleapis.com");
    }

    PsGoogle(String gapp, String gkey, String uri, String gurl, String aurl) {
        this.app = gapp;
        this.key = gkey;
        this.redir = uri;
        this.gauth = gurl;
        this.gapi = aurl;
    }

    @Override
    public Opt<Identity> enter(Request request) throws IOException {
        Href href = new RqHref.Base(request).href();
        Iterator<String> code = href.param(CODE).iterator();
        if (!code.hasNext()) {
            throw new HttpException(400, "code is not provided by Google, probably some mistake");
        }
        return new Opt.Single<Identity>(this.fetch(this.token(code.next())));
    }

    @Override
    public Response exit(Response response, Identity identity) {
        return response;
    }

    private Identity fetch(String token) throws IOException {
        String uri = new Href(this.gapi).path("plus").path("v1").path("people").path("me").with(ACCESS_TOKEN, token).toString();
        JsonObject json = ((JsonResponse)new JdkRequest(uri).fetch().as(JsonResponse.class)).json().readObject();
        if (json.containsKey((Object)ERROR)) {
            throw new HttpException(400, String.format("could not retrieve id from Google, possible cause: %s.", json.getJsonObject(ERROR).get((Object)"message")));
        }
        return PsGoogle.parse(json);
    }

    private String token(String code) throws IOException {
        return ((JsonResponse)((RestResponse)new JdkRequest(new Href(this.gauth).path("o").path("oauth2").path("token").toString()).body().formParam("client_id", (Object)this.app).formParam("redirect_uri", (Object)this.redir).formParam("client_secret", (Object)this.key).formParam("grant_type", (Object)"authorization_code").formParam(CODE, (Object)code).back().header("Content-Type", (Object)"application/x-www-form-urlencoded").method("POST").fetch().as(RestResponse.class)).assertStatus(200).as(JsonResponse.class)).json().readObject().getString(ACCESS_TOKEN);
    }

    private static Identity parse(JsonObject json) {
        HashMap<String, String> props = new HashMap<String, String>(json.size());
        Opt.Single<JsonObject> image = new Opt.Single<JsonObject>(json.getJsonObject("image"));
        if (image.has()) {
            props.put(PICTURE, ((JsonObject)image.get()).getString("url", "#"));
        } else {
            props.put(PICTURE, "#");
        }
        props.put(NAME, json.getString(DISPLAY_NAME, "unknown"));
        return new Identity.Simple(String.format("urn:google:%s", json.getString("id")), props);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsGoogle)) {
            return false;
        }
        PsGoogle other = (PsGoogle)o;
        String this$app = this.app;
        String other$app = other.app;
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$redir = this.redir;
        String other$redir = other.redir;
        return !(this$redir == null ? other$redir != null : !this$redir.equals(other$redir));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $app = this.app;
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $redir = this.redir;
        result = result * 59 + ($redir == null ? 43 : $redir.hashCode());
        return result;
    }
}

