/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.cookies;

import java.util.regex.Pattern;
import org.takes.Response;
import org.takes.rs.RsEmpty;
import org.takes.rs.RsWithHeader;
import org.takes.rs.RsWrap;

public final class RsWithCookie
extends RsWrap {
    private static final Pattern CVALUE_PTRN = Pattern.compile("[\\x21\\x23-\\x2B\\x2D-\\x3A\\x3C-\\x5B\\x5D-\\x7E]*|\"[\\x21\\x23-\\x2B\\x2D-\\x3A\\x3C-\\x5B\\x5D-\\x7E]*\"");
    private static final Pattern CNAME_PTRN = Pattern.compile("[\\x20-\\x7E&&[^()<>@,;:\\\"/\\[\\]?={} ]]+");
    private static final CharSequence SET_COOKIE = "Set-Cookie";

    public RsWithCookie(CharSequence name, CharSequence value, CharSequence ... attrs) {
        this(new RsEmpty(), name, value, attrs);
    }

    public RsWithCookie(Response res, CharSequence name, CharSequence value, CharSequence ... attrs) {
        super(new RsWithHeader(res, SET_COOKIE, RsWithCookie.make(RsWithCookie.validName(name), RsWithCookie.validValue(value), attrs)));
    }

    private static String make(CharSequence name, CharSequence value, CharSequence ... attrs) {
        StringBuilder text = new StringBuilder(String.format("%s=%s;", name, value));
        for (CharSequence attr : attrs) {
            text.append(attr).append(';');
        }
        return text.toString();
    }

    private static CharSequence validValue(CharSequence value) {
        if (!CVALUE_PTRN.matcher(value).matches()) {
            throw new IllegalArgumentException(String.format("Cookie value \"%s\" contains invalid characters", value));
        }
        return value;
    }

    private static CharSequence validName(CharSequence name) {
        if (!CNAME_PTRN.matcher(name).matches()) {
            throw new IllegalArgumentException(String.format("Cookie name \"%s\" contains invalid characters", name));
        }
        return name;
    }

    @Override
    public String toString() {
        return "RsWithCookie(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RsWithCookie)) {
            return false;
        }
        RsWithCookie other = (RsWithCookie)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RsWithCookie;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

