/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fallback;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.takes.Response;
import org.takes.facets.fallback.Fallback;
import org.takes.facets.fallback.FbWrap;
import org.takes.facets.fallback.RqFallback;
import org.takes.misc.Opt;
import org.takes.misc.Utf8PrintStream;
import org.takes.rq.RqHref;
import org.takes.rq.RqMethod;

public final class FbLog4j
extends FbWrap {
    public FbLog4j() {
        super(new Fallback(){

            @Override
            public Opt<Response> route(RqFallback req) throws IOException {
                FbLog4j.log(req);
                return new Opt.Empty<Response>();
            }
        });
    }

    private static void log(RqFallback req) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Throwable error = req.throwable();
        try (Utf8PrintStream stream = new Utf8PrintStream(baos, false);){
            error.printStackTrace(stream);
        }
        Logger.getLogger(FbLog4j.class).error((Object)String.format("%s %s failed with %s: %s", new RqMethod.Base(req).method(), new RqHref.Base(req).href(), req.code(), baos.toString("UTF-8")));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FbLog4j)) {
            return false;
        }
        FbLog4j other = (FbLog4j)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FbLog4j;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

