/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fallback;

import java.util.regex.Pattern;
import org.cactoos.iterable.Filtered;
import org.cactoos.list.ListOf;
import org.takes.Response;
import org.takes.Scalar;
import org.takes.Take;
import org.takes.facets.fallback.Fallback;
import org.takes.facets.fallback.FbWrap;
import org.takes.facets.fallback.RqFallback;
import org.takes.misc.Opt;
import org.takes.rs.RsWithBody;
import org.takes.rs.RsWithStatus;
import org.takes.rs.RsWithType;
import org.takes.tk.TkFixed;

public final class FbStatus
extends FbWrap {
    private static final Pattern WHITESPACE = Pattern.compile("\\s");

    public FbStatus(int code) {
        this(new Filtered<Integer>(value -> code == value, code));
    }

    public FbStatus(Iterable<Integer> check) {
        this(check, new Fallback(){

            @Override
            public Opt<Response> route(RqFallback req) throws Exception {
                RsWithStatus res = new RsWithStatus(req.code());
                return new Opt.Single<Response>(new RsWithType(new RsWithBody((Response)res, String.format("%s: %s", WHITESPACE.split(res.head().iterator().next(), 2)[1], req.throwable().getLocalizedMessage())), "text/plain"));
            }
        });
    }

    public FbStatus(int code, Response response) {
        this(code, new TkFixed(response));
    }

    public FbStatus(int code, final Take take) {
        this(code, new Fallback(){

            @Override
            public Opt<Response> route(RqFallback req) throws Exception {
                return new Opt.Single<Response>(take.act(req));
            }
        });
    }

    public FbStatus(int code, Fallback fallback) {
        this(new Filtered<Integer>(status -> code == status, code), fallback);
    }

    public FbStatus(int code, Scalar<Fallback> fallback) {
        this(new Filtered<Integer>(status -> code == status, code), fallback);
    }

    public FbStatus(Iterable<Integer> check, final Fallback fallback) {
        this(check, new Scalar<Fallback>(){

            @Override
            public Fallback get() {
                return fallback;
            }
        });
    }

    public FbStatus(final Iterable<Integer> check, final Scalar<Fallback> fallback) {
        super(new Fallback(){

            @Override
            public Opt<Response> route(RqFallback req) throws Exception {
                Opt<Response> rsp = new Opt.Empty<Response>();
                if (new ListOf(check).contains(req.code())) {
                    rsp = ((Fallback)fallback.get()).route(req);
                }
                return rsp;
            }
        });
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FbStatus)) {
            return false;
        }
        FbStatus other = (FbStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FbStatus;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }
}

