/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fallback;

import java.io.IOException;
import java.io.InputStream;
import org.takes.HttpException;
import org.takes.Request;
import org.takes.rq.RqFake;

public interface RqFallback
extends Request {
    public int code();

    public Throwable throwable();

    public static final class Fake
    implements RqFallback {
        private final Request request;
        private final int status;
        private final Throwable err;

        public Fake(int code) {
            this(code, new HttpException(code));
        }

        public Fake(int code, Throwable error) {
            this(new RqFake(), code, error);
        }

        public Fake(Request req, int code, Throwable error) {
            this.request = req;
            this.status = code;
            this.err = error;
        }

        @Override
        public int code() {
            return this.status;
        }

        @Override
        public Throwable throwable() {
            return this.err;
        }

        @Override
        public Iterable<String> head() throws IOException {
            return this.request.head();
        }

        @Override
        public InputStream body() throws IOException {
            return this.request.body();
        }
    }
}

