/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.flash;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.takes.Request;
import org.takes.facets.cookies.RqCookies;
import org.takes.facets.flash.RsFlash;
import org.takes.rs.xe.XeSource;
import org.xembly.Directive;
import org.xembly.Directives;

public final class XeFlash
implements XeSource {
    private static final Pattern PTN = Pattern.compile("^(.*?)/(.*?)$");
    private final Request req;
    private final String cookie;

    public XeFlash(Request request) {
        this(request, RsFlash.class.getSimpleName());
    }

    public XeFlash(Request request, String name) {
        this.req = request;
        this.cookie = name;
    }

    @Override
    public Iterable<Directive> toXembly() throws IOException {
        Matcher matcher;
        Iterator<String> cookies = new RqCookies.Base(this.req).cookie(this.cookie).iterator();
        Directives dirs = new Directives();
        if (cookies.hasNext() && (matcher = PTN.matcher(cookies.next())).find()) {
            dirs.add((Object)"flash").add((Object)"message").set((Object)URLDecoder.decode(matcher.group(1), Charset.defaultCharset().name())).up().add((Object)"level").set((Object)matcher.group(2));
        }
        return dirs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XeFlash)) {
            return false;
        }
        XeFlash other = (XeFlash)o;
        Request this$req = this.req;
        Request other$req = other.req;
        if (this$req == null ? other$req != null : !this$req.equals(other$req)) {
            return false;
        }
        String this$cookie = this.cookie;
        String other$cookie = other.cookie;
        return !(this$cookie == null ? other$cookie != null : !this$cookie.equals(other$cookie));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $req = this.req;
        result = result * 59 + ($req == null ? 43 : $req.hashCode());
        String $cookie = this.cookie;
        result = result * 59 + ($cookie == null ? 43 : $cookie.hashCode());
        return result;
    }
}

