/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fork;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.facets.fork.Fork;
import org.takes.facets.fork.am.AgentMatch;
import org.takes.misc.Opt;
import org.takes.rq.RqHeaders;

public final class FkAgent
implements Fork {
    private static final Pattern PATTERN = Pattern.compile("(\\w+)\\/([\\d\\.]+)");
    private final Take take;
    private final AgentMatch match;

    public FkAgent(Take take, AgentMatch match) {
        this.take = take;
        this.match = match;
    }

    @Override
    public Opt<Response> route(Request req) throws Exception {
        List<String> tokens = FkAgent.tokens(req);
        Opt<Response> resp = new Opt.Empty<Response>();
        for (String token : tokens) {
            if (!this.match.matches(token)) continue;
            resp = new Opt.Single<Response>(this.take.act(req));
            break;
        }
        return resp;
    }

    private static List<String> tokens(Request req) throws IOException {
        LinkedList<String> tokens = new LinkedList<String>();
        List<String> headers = new RqHeaders.Base(req).header("User-Agent");
        for (String header : headers) {
            Matcher matcher = PATTERN.matcher(header);
            if (!matcher.matches()) continue;
            tokens.add(matcher.group());
        }
        return tokens;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FkAgent)) {
            return false;
        }
        FkAgent other = (FkAgent)o;
        Take this$take = this.take;
        Take other$take = other.take;
        if (this$take == null ? other$take != null : !this$take.equals(other$take)) {
            return false;
        }
        AgentMatch this$match = this.match;
        AgentMatch other$match = other.match;
        return !(this$match == null ? other$match != null : !this$match.equals(other$match));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Take $take = this.take;
        result = result * 59 + ($take == null ? 43 : $take.hashCode());
        AgentMatch $match = this.match;
        result = result * 59 + ($match == null ? 43 : $match.hashCode());
        return result;
    }
}

