/*
 * Decompiled with CFR 0.152.
 */
package org.takes.facets.fork;

import java.io.IOException;
import java.util.List;
import org.takes.Request;
import org.takes.Response;
import org.takes.Take;
import org.takes.facets.fork.Fork;
import org.takes.facets.fork.MediaTypes;
import org.takes.misc.Opt;
import org.takes.rq.RqHeaders;
import org.takes.tk.TkFixed;

public final class FkContentType
implements Fork {
    private final MediaTypes type;
    private final Take take;

    public FkContentType(String atype, Response response) {
        this(atype, new TkFixed(response));
    }

    public FkContentType(String atype, Take take) {
        this.type = new MediaTypes(atype);
        this.take = take;
    }

    @Override
    public Opt<Response> route(Request req) throws Exception {
        Opt<Response> resp = FkContentType.getType(req).contains(this.type) ? new Opt.Single<Response>(this.take.act(req)) : new Opt.Empty<Response>();
        return resp;
    }

    private static MediaTypes getType(Request req) throws IOException {
        MediaTypes list = new MediaTypes();
        List<String> headers = new RqHeaders.Base(req).header("Content-Type");
        for (String hdr : headers) {
            list = list.merge(new MediaTypes(hdr));
        }
        if (list.isEmpty()) {
            list = new MediaTypes("*/*");
        }
        return list;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FkContentType)) {
            return false;
        }
        FkContentType other = (FkContentType)o;
        MediaTypes this$type = this.type;
        MediaTypes other$type = other.type;
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Take this$take = this.take;
        Take other$take = other.take;
        return !(this$take == null ? other$take != null : !this$take.equals(other$take));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MediaTypes $type = this.type;
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Take $take = this.take;
        result = result * 59 + ($take == null ? 43 : $take.hashCode());
        return result;
    }
}

